package ru.yandex.direct.core.entity.dynamictextadtarget.repository;

import java.math.BigDecimal;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRuleType;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterConditionDBFormatSerializer;

import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class DynamicTextAdTargetMapping {
    private static final ObjectMapper objectMapper = createObjectMapper();

    public static final String SUSPENDED_OPT = "suspended";

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.AUTO_DETECT_CREATORS,
                MapperFeature.AUTO_DETECT_FIELDS,
                MapperFeature.AUTO_DETECT_GETTERS,
                MapperFeature.AUTO_DETECT_IS_GETTERS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public static String optsToDb(Boolean isSuspended) {
        if (isSuspended == null) {
            return null;
        }

        return isSuspended ? SUSPENDED_OPT : "";
    }

    public static Boolean optsFromDb(String opts) {
        if (opts == null) {
            return null;
        }

        return opts.trim().equals(SUSPENDED_OPT);
    }

    public static BigDecimal priceToDbFormat(BigDecimal price) {
        return price == null ? BigDecimal.ZERO : price;
    }

    public static BigDecimal priceFromDbFormat(BigDecimal price) {
        return price == null || price.compareTo(BigDecimal.ZERO) == 0 ? null : price;
    }

    public static String webpageRulesToJson(List<WebpageRule> rules) {
        try {
            return objectMapper.writeValueAsString(rules);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("can not serialize object to json", e);
        }
    }

    public static List<WebpageRule> webpageRulesFromJson(String jsonRules) {
        return StreamEx.of(fromJson(jsonRules, WebpageRule[].class)).toList();
    }

    public static String dynamicFeedRulesToJson(List<DynamicFeedRule> rules) {
        return PerformanceFilterConditionDBFormatSerializer.INSTANCE.serialize(rules);
    }

    public static String serializeForDynamicConditionHash(List<DynamicFeedRule> rules) {
        return PerformanceFilterConditionDBFormatSerializer.INSTANCE.serializeForDynamicConditionHash(rules);
    }

    public static boolean isAllPageCondition(List<WebpageRule> conditions) {
        if (conditions.size() == 1) {
            WebpageRule rule = conditions.get(0);
            if (rule.getType() == null || rule.getType() == WebpageRuleType.ANY) {
                return true;
            }
        }
        return false;
    }
}
