package ru.yandex.direct.core.entity.dynamictextadtarget.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicTextAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.repository.DynamicTextAdTargetRepository;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.AddDynamicFeedAdTargetValidationService;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.AddDynamicTextAdTargetValidationService;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;

@Component
public class DynamicAdTargetsAddOperationFactory {

    private final ShardHelper shardHelper;
    private final AddDynamicTextAdTargetValidationService addDynamicTextAdTargetValidationService;
    private final AddDynamicFeedAdTargetValidationService addDynamicFeedAdTargetValidationService;
    private final AdGroupRepository adGroupRepository;
    private final DynamicTextAdTargetRepository dynamicTextAdTargetRepository;
    private final DslContextProvider dslContextProvider;
    private final DynamicAdTargetsAddOperationHelper dynamicAdTargetsAddOperationHelper;
    private final DynamicAdTargetsUpdateOperationHelper dynamicAdTargetsUpdateOperationHelper;
    private final ClientService clientService;

    @Autowired
    public DynamicAdTargetsAddOperationFactory(ShardHelper shardHelper,
                                               AddDynamicTextAdTargetValidationService addDynamicTextAdTargetValidationService,
                                               AddDynamicFeedAdTargetValidationService addDynamicFeedAdTargetValidationService,
                                               AdGroupRepository adGroupRepository,
                                               DynamicTextAdTargetRepository dynamicTextAdTargetRepository,
                                               DslContextProvider dslContextProvider,
                                               DynamicAdTargetsAddOperationHelper dynamicAdTargetsAddOperationHelper,
                                               DynamicAdTargetsUpdateOperationHelper dynamicAdTargetsUpdateOperationHelper,
                                               ClientService clientService) {
        this.shardHelper = shardHelper;
        this.addDynamicTextAdTargetValidationService = addDynamicTextAdTargetValidationService;
        this.addDynamicFeedAdTargetValidationService = addDynamicFeedAdTargetValidationService;
        this.adGroupRepository = adGroupRepository;
        this.dynamicTextAdTargetRepository = dynamicTextAdTargetRepository;
        this.dslContextProvider = dslContextProvider;
        this.dynamicAdTargetsAddOperationHelper = dynamicAdTargetsAddOperationHelper;
        this.dynamicAdTargetsUpdateOperationHelper = dynamicAdTargetsUpdateOperationHelper;
        this.clientService = clientService;
    }

    public DynamicTextAdTargetsAddOperation createDynamicTextAdTargetsAddOperation(
            ClientId clientId, Long operatorUid, List<DynamicTextAdTarget> dynamicTextAdTargets) {

        int shard = shardHelper.getShardByClientIdStrictly(clientId);

        return new DynamicTextAdTargetsAddOperation(
                Applicability.PARTIAL, dynamicTextAdTargets, clientId, operatorUid, shard,
                addDynamicTextAdTargetValidationService, adGroupRepository, dslContextProvider,
                dynamicAdTargetsAddOperationHelper, clientService);
    }

    public DynamicFeedAdTargetsAddOperation createDynamicFeedAdTargetsAddOperation(
            ClientId clientId, Long operatorUid, List<DynamicFeedAdTarget> dynamicFeedAdTargets) {

        int shard = shardHelper.getShardByClientIdStrictly(clientId);

        return new DynamicFeedAdTargetsAddOperation(
                Applicability.PARTIAL, dynamicFeedAdTargets, clientId, operatorUid, shard,
                addDynamicFeedAdTargetValidationService, adGroupRepository, dslContextProvider,
                dynamicAdTargetsAddOperationHelper, clientService);
    }

    public DynamicTextAdTargetsUpdateOperation createDynamicTextAdTargetsUpdateOperation(
            ClientId clientId, long operatorUid, List<ModelChanges<DynamicTextAdTarget>> modelChangesList) {

        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        Currency currency = clientService.getWorkCurrency(clientId);

        return new DynamicTextAdTargetsUpdateOperation(
                Applicability.PARTIAL, modelChangesList,
                dynamicAdTargetsUpdateOperationHelper, addDynamicTextAdTargetValidationService,
                dynamicTextAdTargetRepository, adGroupRepository, dslContextProvider,
                shard, clientId, currency, operatorUid);
    }

    public DynamicFeedAdTargetsUpdateOperation createDynamicFeedAdTargetsUpdateOperation(
            ClientId clientId, long operatorUid, List<ModelChanges<DynamicFeedAdTarget>> modelChangesList) {

        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        Currency currency = clientService.getWorkCurrency(clientId);

        return new DynamicFeedAdTargetsUpdateOperation(
                Applicability.PARTIAL, modelChangesList,
                dynamicAdTargetsUpdateOperationHelper, addDynamicFeedAdTargetValidationService,
                dynamicTextAdTargetRepository, adGroupRepository, dslContextProvider,
                shard, clientId, currency, operatorUid);
    }
}
