package ru.yandex.direct.core.entity.dynamictextadtarget.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.banner.repository.BannerCommonRepository;
import ru.yandex.direct.core.entity.dynamictextadtarget.repository.DynamicTextAdTargetRepository;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.SuspendResumeDynamicFeedAdTargetValidationService;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.SuspendResumeDynamicTextAdTargetValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.result.MassResult;

@Service
@ParametersAreNonnullByDefault
public class DynamicTextAdTargetSuspendResumeService {

    private final ShardHelper shardHelper;
    private final SuspendResumeDynamicTextAdTargetValidationService textValidationService;
    private final SuspendResumeDynamicFeedAdTargetValidationService feedValidationService;
    private final DynamicTextAdTargetRepository dynamicTextAdTargetRepository;
    private final AdGroupRepository adGroupRepository;
    private final BannerCommonRepository bannerCommonRepository;
    private final DslContextProvider ppcDslContextProvider;

    public DynamicTextAdTargetSuspendResumeService(ShardHelper shardHelper,
                                                   SuspendResumeDynamicTextAdTargetValidationService textValidationService,
                                                   SuspendResumeDynamicFeedAdTargetValidationService feedValidationService,
                                                   DynamicTextAdTargetRepository dynamicTextAdTargetRepository,
                                                   AdGroupRepository adGroupRepository,
                                                   BannerCommonRepository bannerCommonRepository,
                                                   DslContextProvider ppcDslContextProvider) {
        this.shardHelper = shardHelper;
        this.textValidationService = textValidationService;
        this.feedValidationService = feedValidationService;
        this.dynamicTextAdTargetRepository = dynamicTextAdTargetRepository;
        this.adGroupRepository = adGroupRepository;
        this.bannerCommonRepository = bannerCommonRepository;
        this.ppcDslContextProvider = ppcDslContextProvider;
    }

    public MassResult<Long> suspendDynamicTextAdTargets(ClientId clientId, Long operatorUid,
                                                        List<Long> ids) {
        return createDynamicTextAdTargetsSuspendResumeOperation(clientId, operatorUid, ids, false).prepareAndApply();
    }

    public MassResult<Long> suspendDynamicFeedAdTargets(ClientId clientId, Long operatorUid,
                                                        List<Long> ids) {
        return createDynamicFeedAdTargetsSuspendResumeOperation(clientId, operatorUid, ids, false).prepareAndApply();
    }

    public MassResult<Long> resumeDynamicTextAdTargets(ClientId clientId, Long operatorUid,
                                                       List<Long> ids) {
        return createDynamicTextAdTargetsSuspendResumeOperation(clientId, operatorUid, ids, true).prepareAndApply();
    }

    public MassResult<Long> resumeDynamicFeedAdTargets(ClientId clientId, Long operatorUid,
                                                       List<Long> ids) {
        return createDynamicFeedAdTargetsSuspendResumeOperation(clientId, operatorUid, ids, true).prepareAndApply();
    }

    private DynamicTextAdTargetsSuspendResumeOperation createDynamicTextAdTargetsSuspendResumeOperation(
            ClientId clientId,
            Long operatorUid,
            List<Long> ids,
            boolean isResumeOperation) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new DynamicTextAdTargetsSuspendResumeOperation(shard, clientId, operatorUid, ids,
                isResumeOperation, textValidationService, dynamicTextAdTargetRepository, adGroupRepository,
                bannerCommonRepository, ppcDslContextProvider);
    }

    private DynamicFeedAdTargetsSuspendResumeOperation createDynamicFeedAdTargetsSuspendResumeOperation(
            ClientId clientId,
            Long operatorUid,
            List<Long> ids,
            boolean isResumeOperation) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new DynamicFeedAdTargetsSuspendResumeOperation(shard, clientId, operatorUid, ids,
                isResumeOperation, feedValidationService, dynamicTextAdTargetRepository, adGroupRepository,
                bannerCommonRepository, ppcDslContextProvider);
    }
}
