package ru.yandex.direct.core.entity.dynamictextadtarget.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.banner.repository.BannerCommonRepository;
import ru.yandex.direct.core.entity.dynamictextadtarget.repository.DynamicTextAdTargetRepository;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DeleteDynamicTextAdTargetValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.operation.Applicability;

@Component
public class DynamicTextAdTargetsDeleteOperationFactory {

    private final DslContextProvider ppcDslContextProvider;
    private final DeleteDynamicTextAdTargetValidationService deleteDynamicTextAdTargetValidationService;
    private final DynamicTextAdTargetRepository dynamicTextAdTargetRepository;
    private final AdGroupRepository adGroupRepository;
    private final BannerCommonRepository bannerCommonRepository;
    private final ShardHelper shardHelper;

    @Autowired
    public DynamicTextAdTargetsDeleteOperationFactory(
            DslContextProvider ppcDslContextProvider,
            DeleteDynamicTextAdTargetValidationService deleteDynamicTextAdTargetValidationService,
            DynamicTextAdTargetRepository dynamicTextAdTargetRepository,
            AdGroupRepository adGroupRepository,
            BannerCommonRepository bannerCommonRepository,
            ShardHelper shardHelper) {
        this.ppcDslContextProvider = ppcDslContextProvider;
        this.deleteDynamicTextAdTargetValidationService = deleteDynamicTextAdTargetValidationService;
        this.dynamicTextAdTargetRepository = dynamicTextAdTargetRepository;
        this.adGroupRepository = adGroupRepository;
        this.bannerCommonRepository = bannerCommonRepository;
        this.shardHelper = shardHelper;
    }

    public DynamicTextAdTargetsDeleteOperation createDeleteOperation(long operatorUid, ClientId clientId,
                                                                     List<Long> dynamicTextAdTargetIds) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new DynamicTextAdTargetsDeleteOperation(shard, clientId, operatorUid, Applicability.PARTIAL,
                dynamicTextAdTargetIds,
                ppcDslContextProvider, deleteDynamicTextAdTargetValidationService, dynamicTextAdTargetRepository,
                adGroupRepository, bannerCommonRepository);
    }
}
