package ru.yandex.direct.core.entity.dynamictextadtarget.service;

import java.util.function.Function;

import ru.yandex.direct.core.entity.bids.container.BidSelectionCriteria;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicTextAdTarget;

public enum RequestSetBidType {
    ID(BidSelectionCriteria::getId, DynamicTextAdTarget::getDynamicConditionId,
            DynamicFeedAdTarget::getDynamicConditionId),
    ADGROUP_ID(BidSelectionCriteria::getAdGroupId, DynamicTextAdTarget::getAdGroupId,
            DynamicFeedAdTarget::getAdGroupId),
    CAMPAIGN_ID(BidSelectionCriteria::getCampaignId, DynamicTextAdTarget::getCampaignId,
            DynamicFeedAdTarget::getCampaignId);

    private final Function<BidSelectionCriteria, Long> bidCriteriaSupplier;
    private final Function<DynamicTextAdTarget, Long> dynamicTextAdTargetSupplier;
    private final Function<DynamicFeedAdTarget, Long> dynamicFeedAdTargetSupplier;

    RequestSetBidType(Function<BidSelectionCriteria, Long> bidCriteriaSupplier,
                      Function<DynamicTextAdTarget, Long> dynamicTextAdTargetSupplier,
                      Function<DynamicFeedAdTarget, Long> dynamicFeedAdTargetSupplier) {
        this.bidCriteriaSupplier = bidCriteriaSupplier;
        this.dynamicTextAdTargetSupplier = dynamicTextAdTargetSupplier;
        this.dynamicFeedAdTargetSupplier = dynamicFeedAdTargetSupplier;
    }

    public Long getId(BidSelectionCriteria selectionCriteria) {
        return bidCriteriaSupplier.apply(selectionCriteria);
    }

    public Long getId(DynamicTextAdTarget dynamicTextAdTarget) {
        return dynamicTextAdTargetSupplier.apply(dynamicTextAdTarget);
    }

    public Long getId(DynamicFeedAdTarget dynamicFeedAdTarget) {
        return dynamicFeedAdTargetSupplier.apply(dynamicFeedAdTarget);
    }
}
