package ru.yandex.direct.core.entity.dynamictextadtarget.service.validation;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignAccessDefects;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignSubObjectAccessCheckerFactory;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignSubObjectAccessConstraint;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignAccessType;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.campaign.service.accesschecker.AccessDefectPresets.DEFAULT_DEFECTS;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.unique;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;
import static ru.yandex.direct.validation.defect.CollectionDefects.duplicatedObject;
import static ru.yandex.direct.validation.defect.CommonDefects.objectNotFound;

@Service
public class DeleteDynamicTextAdTargetValidationService {

    private static final CampaignAccessDefects ACCESS_DEFECTS = DEFAULT_DEFECTS.toBuilder()
            .withNotVisible(objectNotFound())
            .build();

    private final CampaignSubObjectAccessCheckerFactory campaignSubObjectAccessCheckerFactory;

    @Autowired
    public DeleteDynamicTextAdTargetValidationService(CampaignSubObjectAccessCheckerFactory campaignSubObjectAccessCheckerFactory) {
        this.campaignSubObjectAccessCheckerFactory = campaignSubObjectAccessCheckerFactory;
    }

    public ValidationResult<List<Long>, Defect> validateDelete(Long operatorUid, ClientId clientId,
                                                               List<Long> requestedConditionIds) {

        ListValidationBuilder<Long, Defect> lvb = ListValidationBuilder.of(requestedConditionIds);

        CampaignSubObjectAccessConstraint accessConstraint = campaignSubObjectAccessCheckerFactory
                .newDynamicAdTargetChecker(operatorUid, clientId, requestedConditionIds)
                .createValidator(CampaignAccessType.READ_WRITE, ACCESS_DEFECTS)
                .getAccessConstraint();

        lvb
                .check(notNull())
                .checkEach(notNull(), When.isValid())
                .checkEach(validId(), When.isValid())
                .checkEach(unique(), duplicatedObject(), When.isValid())
                .checkEach(accessConstraint, When.isValid());

        return lvb.getResult();
    }
}
