package ru.yandex.direct.core.entity.dynamictextadtarget.service.validation;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRuleKind;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRuleType;
import ru.yandex.direct.core.entity.dynamictextadtarget.utils.DynamicTextAdTargetHashUtils;

import static ru.yandex.direct.utils.TextConstants.LETTERS_AND_NUMBERS;
import static ru.yandex.direct.utils.TextConstants.PUNCTUATION;
import static ru.yandex.direct.utils.TextConstants.SPACE_CHARS;
import static ru.yandex.direct.utils.TextConstants.SPECIAL_CHARS;

public class DynamicTextAdTargetConstants {

    public static final int MAX_DYNAMIC_TEXT_AD_TARGETS_IN_GROUP = 50;
    public static final int NORMAL_AUTOBUDGET_PRIORITY = 3;
    public static final List<WebpageRule> ALL_PAGE_CONDITION =
            Collections.singletonList(new WebpageRule().withType(WebpageRuleType.ANY));
    public static final Integer ALL_PAGE_CONDITION_UNIQ_HASH =
            DynamicTextAdTargetHashUtils.getUniqHash(ALL_PAGE_CONDITION);

    public static final Set<AdGroupType> ALLOWED_DYNAMIC_AD_GROUP_TYPES =
            EnumSet.of(AdGroupType.BASE, AdGroupType.DYNAMIC);


    private static final int MAX_OFFERS_LIST_URL_LENGTH = 1024;
    private static final int MAX_ARGUMENT_LENGTH = 100;
    public static final int MAX_NAME_LENGTH = 100;
    public static final int MIN_ARGUMENTS = 1;
    public static final int MAX_ARGUMENTS = 10;

    public static final int MIN_CONDITIONS_PER_WEBPAGE = 1;
    public static final int MAX_CONDITIONS_PER_WEBPAGE = 10;

    public static final String ALLOW_LETTERS =
            LETTERS_AND_NUMBERS + SPACE_CHARS + SPECIAL_CHARS + PUNCTUATION;

    public static final ImmutableMap<WebpageRuleType, Integer>
            WEBPAGE_RULE_AVAILABLE_ARGUMENT_LENGTH =
            ImmutableMap.<WebpageRuleType, Integer>builder()
                    .put(WebpageRuleType.CONTENT, MAX_ARGUMENT_LENGTH)
                    .put(WebpageRuleType.TITLE, MAX_ARGUMENT_LENGTH)
                    .put(WebpageRuleType.URL, MAX_ARGUMENT_LENGTH)
                    .put(WebpageRuleType.DOMAIN, MAX_ARGUMENT_LENGTH)
                    .put(WebpageRuleType.URL_PRODLIST, MAX_OFFERS_LIST_URL_LENGTH)
                    .build();

    public static final ImmutableSet<WebpageRuleType> URL_RULE = ImmutableSet.<WebpageRuleType>builder()
            .add(WebpageRuleType.URL, WebpageRuleType.URL_PRODLIST)
            .build();

    public static final ImmutableMap<WebpageRuleType, ImmutableSet<WebpageRuleKind>>
            WEBPAGE_RULE_AVAILABLE_OPERATIONS =
            ImmutableMap.<WebpageRuleType, ImmutableSet<WebpageRuleKind>>builder()
                    .put(WebpageRuleType.URL_PRODLIST,
                            ImmutableSet.of(WebpageRuleKind.EQUALS, WebpageRuleKind.NOT_EQUALS))
                    .put(WebpageRuleType.DOMAIN, ImmutableSet.of(WebpageRuleKind.EXACT, WebpageRuleKind.NOT_EXACT))
                    .put(WebpageRuleType.URL, ImmutableSet.of(WebpageRuleKind.EXACT, WebpageRuleKind.NOT_EXACT))
                    .put(WebpageRuleType.TITLE, ImmutableSet.of(WebpageRuleKind.EXACT, WebpageRuleKind.NOT_EXACT))
                    .put(WebpageRuleType.CONTENT, ImmutableSet.of(WebpageRuleKind.EXACT, WebpageRuleKind.NOT_EXACT))
                    .put(WebpageRuleType.ANY, ImmutableSet.of())
                    .build();
}
