package ru.yandex.direct.core.entity.dynamictextadtarget.service.validation;

import com.google.common.base.CharMatcher;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static com.google.common.base.CharMatcher.anyOf;
import static ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DynamicTextAdTargetConstants.ALLOW_LETTERS;
import static ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DynamicTextAdTargetDefects.invalidEmptyNameFormat;
import static ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DynamicTextAdTargetDefects.invalidEmptyUrlFormat;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.defect.StringDefects.admissibleChars;

class DynamicTextAdTargetConstraints {

    private static final CharMatcher ALLOW_LETTERS_MATCHER = anyOf(ALLOW_LETTERS);

    private DynamicTextAdTargetConstraints() {
    }

    /**
     * Проверка допустимых символов
     */
    static Constraint<String, Defect> allowedChars() {
        return fromPredicate(ALLOW_LETTERS_MATCHER::matchesAllOf, admissibleChars());
    }

    /**
     * Проверка на пустую строку (null, "", "  ")
     */
    static Constraint<String, Defect> isNotBlankUrl(int argId, int ruleId) {
        return Constraint.fromPredicate(StringUtils::isNotBlank, invalidEmptyUrlFormat(argId, ruleId));
    }

    /**
     * Проверка на пустую строку (null, "", "  ")
     */
    static Constraint<String, Defect> isNotBlankName() {
        return Constraint.fromPredicate(StringUtils::isNotBlank, invalidEmptyNameFormat());
    }
}
