package ru.yandex.direct.core.entity.dynamictextadtarget.service.validation;

import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.core.validation.defects.params.NumberWithIdDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class DynamicTextAdTargetDefectIds {

    public enum Gen implements DefectId<Void> {
        NOT_ACCEPTABLE_AD_GROUP_TYPE,
        ALL_PAGE_CONDITION_NOT_WITH_ANOTHER,
        AD_GROUP_NOT_FOUND,
        ALREADY_SUSPENDED,
        IS_NOT_SUSPENDED,
        DUPLICATE_RULES_IN_CONDITION
    }

    public enum IdParametrized implements DefectId<ModelIdDefectParams> {
        DYNAMIC_TEXT_AD_TARGET_NOT_FOUND_IN_CAMPAIGN,
        DYNAMIC_TEXT_AD_TARGET_NOT_FOUND_IN_AD_GROUP
    }

    public enum Num implements DefectId<NumberDefectParams> {
        MAX_COUNT_IN_ADGROUP,
        NUMBER_OF_RULES_MUST_BE_FROM_TO,
        INVALID_FORMAT_WEBPAGE_CONDITION
    }

    public enum Strings implements DefectId<NumberWithIdDefectParams> {
        /**
         * Количество аргументов в правиле  №{0} условия нацеливания должно быть от {1} до {2}
         */
        NUMBER_ARGUMENTS_MUST_BE_FROM_TO,
        /**
         * Превышена максимальная длина значения №{0} правила №{1} в {2} символов
         */
        EXCEEDED_MAX_LENGTH_IN_ARGUMENTS,
        /**
         * Неправильный формат ссылки №{0} для правила №{1}
         */
        INVALID_URL_FORMAT,
        /**
         * Неправильный формат правила: значение №{0} правила №{1} должно содержать хотя бы один значащий символ
         */
        INVALID_EMPTY_URL_FORMAT,
        /**
         * НВ значении №{0} правила №{1} допускается использование букв латинского, турецкого, русского, украинского, казахского алфавитов, цифр и
         * знаков пунктуации.
         */
        INVALID_LETTERS_IN_RULE,
        /**
         * Значение в поле Name не должно превышать {0} символов
         */
        EXCEEDED_MAX_LENGTH_IN_NAME,
        /**
         * Не указано значение в поле Name
         */
        INVALID_EMPTY_NAME_FORMAT,
        /**
         * В поле Name допускается использование букв латинского, турецкого, русского, украинского, казахского, белорусского алфавитов, цифр и
         * знаков пунктуации
         */
        INVALID_LETTERS_IN_NAME,
    }
}
