package ru.yandex.direct.core.entity.dynamictextadtarget.service.validation;

import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.core.validation.defects.params.NumberWithIdDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class DynamicTextAdTargetDefects {

    static Defect<Void> alreadySuspended() {
        return new Defect<>(DynamicTextAdTargetDefectIds.Gen.ALREADY_SUSPENDED);
    }

    static Defect<Void> isNotSuspended() {
        return new Defect<>(DynamicTextAdTargetDefectIds.Gen.IS_NOT_SUSPENDED);
    }

    static Defect dynamicTextAdTargetNotFoundInCampaign(Long dynamicTextAdTargetId) {
        return new Defect<>(DynamicTextAdTargetDefectIds.IdParametrized.DYNAMIC_TEXT_AD_TARGET_NOT_FOUND_IN_CAMPAIGN,
                new ModelIdDefectParams().withId(dynamicTextAdTargetId));
    }

    static Defect dynamicTextAdTargetNotFoundInAdGroup(Long dynamicTextAdTargetId) {
        return new Defect<>(DynamicTextAdTargetDefectIds.IdParametrized.DYNAMIC_TEXT_AD_TARGET_NOT_FOUND_IN_AD_GROUP,
                new ModelIdDefectParams().withId(dynamicTextAdTargetId));
    }

    static Defect<NumberWithIdDefectParams> numberArgumentsMustBeFromTo(int index, int minSize, int maxSize) {
        return new Defect<>(DynamicTextAdTargetDefectIds.Strings.NUMBER_ARGUMENTS_MUST_BE_FROM_TO,
                new NumberWithIdDefectParams().withId1(index).withMin(minSize).withMax(maxSize));
    }

    static Defect<NumberWithIdDefectParams> exceededMaxLengthInArguments(int argId, int ruleId, int maxStringLength) {
        return new Defect<>(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_ARGUMENTS,
                new NumberWithIdDefectParams().withId1(argId).withId2(ruleId).withMax(maxStringLength));
    }

    static Defect<NumberWithIdDefectParams> invalidUrlFormat(int argId, int ruleId) {
        return new Defect<>(DynamicTextAdTargetDefectIds.Strings.INVALID_URL_FORMAT,
                new NumberWithIdDefectParams().withId1(argId).withId2(ruleId));
    }

    static Defect<NumberWithIdDefectParams> invalidEmptyUrlFormat(int argId, int ruleId) {
        return new Defect<>(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_URL_FORMAT,
                new NumberWithIdDefectParams().withId1(argId).withId2(ruleId));
    }

    static Defect<NumberWithIdDefectParams> invalidLettersInRule(int argId, int ruleId) {
        return new Defect<>(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_RULE,
                new NumberWithIdDefectParams().withId1(argId).withId2(ruleId));
    }

    static Defect<NumberWithIdDefectParams> exceededMaxLengthInName(int maxStringLength) {
        return new Defect<>(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_NAME,
                new NumberWithIdDefectParams().withMax(maxStringLength));
    }

    static Defect<NumberDefectParams> numberOfRulesInDynamicTextAdTarget(int min, int max) {
        return new Defect<>(DynamicTextAdTargetDefectIds.Num.NUMBER_OF_RULES_MUST_BE_FROM_TO,
                new NumberDefectParams().withMin(min).withMax(max));
    }

    static Defect<NumberDefectParams> invalidFormatWebpageCondition(int index) {
        return new Defect<>(DynamicTextAdTargetDefectIds.Num.INVALID_FORMAT_WEBPAGE_CONDITION,
                new NumberDefectParams().withMax(index));
    }

    static Defect<Void> duplicateRulesInCondition() {
        return new Defect<>(DynamicTextAdTargetDefectIds.Gen.DUPLICATE_RULES_IN_CONDITION);
    }

    public static Defect<NumberWithIdDefectParams> invalidEmptyNameFormat() {
        return new Defect<>(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_NAME_FORMAT);
    }

    static Defect<NumberWithIdDefectParams> invalidLettersInName() {
        return new Defect<>(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_NAME);
    }

    public static Defect<Void> notAcceptableAdGroupType() {
        return new Defect<>(DynamicTextAdTargetDefectIds.Gen.NOT_ACCEPTABLE_AD_GROUP_TYPE);
    }

    static Defect<Void> allPageConditionNotWithAnother() {
        return new Defect<>(DynamicTextAdTargetDefectIds.Gen.ALL_PAGE_CONDITION_NOT_WITH_ANOTHER);
    }

    public static Defect<Void> adGroupNotFound() {
        return new Defect<>(DynamicTextAdTargetDefectIds.Gen.AD_GROUP_NOT_FOUND);
    }

    public static Defect<NumberDefectParams> maxDynamicTextAdTargetsInAdGroup(int max) {
        return new Defect<>(DynamicTextAdTargetDefectIds.Num.MAX_COUNT_IN_ADGROUP,
                new NumberDefectParams().withMax(max));
    }
}
