package ru.yandex.direct.core.entity.eventlog.model;

import java.time.LocalDateTime;
import java.util.Objects;

public class EventCampaignAndTimeData {
    private EventLogType type;

    private LocalDateTime eventTime;

    private Long campaignId;


    public EventLogType getType() {
        return type;
    }

    public void setType(EventLogType type) {
        this.type = type;
    }

    public EventCampaignAndTimeData withType(EventLogType type) {
        this.type = type;
        return this;
    }

    public LocalDateTime getEventTime() {
        return eventTime;
    }

    public void setEventTime(LocalDateTime eventTime) {
        this.eventTime = eventTime;
    }

    public EventCampaignAndTimeData withEventTime(LocalDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public EventCampaignAndTimeData withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EventCampaignAndTimeData that = (EventCampaignAndTimeData) o;
        return Objects.equals(type, that.type)
                && Objects.equals(eventTime, that.eventTime)
                && Objects.equals(campaignId, that.campaignId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                type,
                eventTime,
                campaignId
        );
    }

    public EventCampaignAndTimeData fromEventLog(EventLog eventLog) {
        this.campaignId = eventLog.getCampaignId();
        this.eventTime = eventLog.getEventTime();
        this.type = eventLog.getType();
        return this;
    }
}
