package ru.yandex.direct.core.entity.feature.container;

import java.util.Objects;

import ru.yandex.direct.dbutil.model.ClientId;

public class FeatureRequest {
    private ClientId clientId;
    private Long uid;
    private String yandexuid;
    private String ip;
    private String userAgent;
    private String host;
    private String yexpCookie;
    private String npFixedFeatures;
    private String interfaceLang;
    private boolean onlyFromDb = false;

    public ClientId getClientId() {
        return clientId;
    }

    public void setClientId(ClientId clientId) {
        this.clientId = clientId;
    }

    public FeatureRequest withClientId(ClientId clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getUid() {
        return uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public FeatureRequest withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public String getYandexuid() {
        return yandexuid;
    }

    public void setYandexuid(String yandexuid) {
        this.yandexuid = yandexuid;
    }

    public FeatureRequest withYandexuid(String yandexuid) {
        this.yandexuid = yandexuid;
        return this;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public FeatureRequest withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public FeatureRequest withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public FeatureRequest withHost(String host) {
        this.host = host;
        return this;
    }

    public String getYexpCookie() {
        return yexpCookie;
    }

    public void setYexpCookie(String yexpCookie) {
        this.yexpCookie = yexpCookie;
    }

    public FeatureRequest withYexpCookie(String yexpCookie) {
        this.yexpCookie = yexpCookie;
        return this;
    }

    public String getNpFixedFeatures() {
        return npFixedFeatures;
    }

    public void setNpFixedFeatures(String npFixedFeatures) {
        this.npFixedFeatures = npFixedFeatures;
    }

    public FeatureRequest withNpFixedFeatures(String npFixedFeatures) {
        this.npFixedFeatures = npFixedFeatures;
        return this;
    }

    public boolean isOnlyFromDb() {
        return onlyFromDb;
    }

    public void setOnlyFromDb(boolean onlyFromDb) {
        this.onlyFromDb = onlyFromDb;
    }


    public FeatureRequest withOnlyFromDb(boolean onlyFromDb) {
        this.onlyFromDb = onlyFromDb;
        return this;
    }

    public String getInterfaceLang() {
        return interfaceLang;
    }

    public void setInterfaceLang(String interfaceLang) {
        this.interfaceLang = interfaceLang;
    }

    public FeatureRequest withInterfaceLang(String interfaceLang) {
        this.interfaceLang = interfaceLang;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FeatureRequest that = (FeatureRequest) o;
        return onlyFromDb == that.onlyFromDb &&
                Objects.equals(clientId, that.clientId) &&
                Objects.equals(uid, that.uid) &&
                Objects.equals(yandexuid, that.yandexuid) &&
                Objects.equals(ip, that.ip) &&
                Objects.equals(userAgent, that.userAgent) &&
                Objects.equals(host, that.host) &&
                Objects.equals(yexpCookie, that.yexpCookie) &&
                Objects.equals(npFixedFeatures, that.npFixedFeatures) &&
                Objects.equals(interfaceLang, that.interfaceLang);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, uid, yandexuid, ip, userAgent, host, interfaceLang, onlyFromDb);
    }

    @Override
    public String toString() {
        return "FeatureRequest{" +
                "clientId=" + clientId +
                ", uid=" + uid +
                ", yandexuid='" + yandexuid + '\'' +
                ", ip='" + ip + '\'' +
                ", userAgent='" + userAgent + '\'' +
                ", host='" + host + '\'' +
                ", interfaceLang='" + interfaceLang + '\'' +
                ", onlyFromDb=" + onlyFromDb +
                '}';
    }
}
