package ru.yandex.direct.core.entity.feature.container;

import java.net.InetAddress;
import java.util.Locale;
import java.util.Optional;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.util.HttpUtil;
import ru.yandex.direct.dbutil.model.ClientId;

@Component
public class FeatureRequestHttpFactory implements FeatureRequestFactory {

    /**
     * Создает FeatureRequest по возможности со всеми данными из http-запроса (куки, ip, UA)
     * Если вызывается не внутри обработки http-запроса, возвращает пустой FeatureRequest
     */
    @Override
    public FeatureRequest get(ClientId clientId, Long uid) {
        if (!HttpUtil.isRequestExists()) {
            return new FeatureRequest().withClientId(clientId).withUid(uid);
        }
        var httpRequest = HttpUtil.getRequest();
        var yandexUid = HttpUtil.getCookieValue("yandexuid", httpRequest).orElse(null);
        var ip = Optional.ofNullable(HttpUtil.getRemoteAddress(httpRequest)).map(InetAddress::getHostAddress).orElse(null);
        var host = HttpUtil.getHeaderValue(httpRequest, "Host").orElse(null);
        var userAgent = HttpUtil.getHeaderValue(httpRequest, "UserAgent").orElse(null);
        var interfaceLangOptional = HttpUtil.getCurrentLocale();
        var yexpCookie = HttpUtil.getCookieValue("yexp", httpRequest).orElse(null);
        var npFixedFeaturesCookie = HttpUtil.getCookieValue("np_fixed_features", httpRequest).orElse(null);

        return new FeatureRequest()
                .withClientId(clientId)
                .withIp(ip)
                .withUid(uid)
                .withHost(host)
                .withYandexuid(yandexUid)
                .withYexpCookie(yexpCookie)
                .withNpFixedFeatures(npFixedFeaturesCookie)
                .withUserAgent(userAgent)
                .withInterfaceLang(interfaceLangOptional.map(Locale::getLanguage).orElse(null));
    }
}
