package ru.yandex.direct.core.entity.feature.container;

import java.util.Collection;
import java.util.Map;

public class FeaturesWithExpBoxes {
    private String expBoxesCrypted;
    private String expBoxes;
    // feature_id -> clientRealFeature
    private Map<Long, ClientRealFeature> idToFeatureMap;

    public FeaturesWithExpBoxes(Map<Long, ClientRealFeature> idToFeatureMap, String expBoxesCrypted, String expBoxes) {
        this.expBoxesCrypted = expBoxesCrypted;
        this.expBoxes = expBoxes;
        this.idToFeatureMap = idToFeatureMap;
    }

    public FeaturesWithExpBoxes(Map<Long, ClientRealFeature> idToFeatureMap) {
        this(idToFeatureMap, "", "");
    }

    public String getExpBoxesCrypted() {
        return expBoxesCrypted;
    }

    public Map<Long, ClientRealFeature> getIdToFeatureMap() {
        return idToFeatureMap;
    }

    public Collection<ClientRealFeature> getFeatures() {
        return idToFeatureMap.values();
    }

    public void setExpBoxesCrypted(String expBoxesCrypted) {
        this.expBoxesCrypted = expBoxesCrypted;
    }

    public FeaturesWithExpBoxes withExpBoxesCrypted(String expBoxesCrypted) {
        this.expBoxesCrypted = expBoxesCrypted;
        return this;
    }

    public String getExpBoxes() {
        return expBoxes;
    }

    public void setExpBoxes(String expBoxes) {
        this.expBoxes = expBoxes;
    }

    public FeaturesWithExpBoxes withExpBoxes(String expBoxes) {
        this.expBoxes = expBoxes;
        return this;
    }
}
