package ru.yandex.direct.core.entity.feature.model;

import java.util.Map;

import ru.yandex.direct.core.entity.feature.container.ClientRealFeature;
import ru.yandex.direct.core.entity.feature.container.FeatureTextIdToClientIdState;

public class FeatureConverter {
    private FeatureConverter() {
    }

    public static ClientFeature clientFeatureFromFeatureTextIdToClientIdState(
            FeatureTextIdToClientIdState featureTextIdToClientIdState,
            Map<String, Feature> featuresByTextId) {
        return new ClientFeature()
                .withClientId(featureTextIdToClientIdState.getClientId())
                .withId(featuresByTextId.get(featureTextIdToClientIdState.getTextId()).getId())
                .withState(featureTextIdToClientIdState.getState());
    }


    public static ClientFeature toClientFeature(ClientRealFeature clientRealFeature) {
        return new ClientFeature()
                .withState(clientRealFeature.getFeatureState())
                .withClientId(clientRealFeature.getClientId())
                .withId(clientRealFeature.getFeature().getId());
    }
}
