package ru.yandex.direct.core.entity.feature.repository;

import ru.yandex.direct.core.entity.feature.model.FeatureSettings;
import ru.yandex.direct.utils.JsonUtils;

import static java.util.Collections.emptySet;

public class FeatureMappings {
    public static FeatureSettings fromDb(String json) {
        FeatureSettings settings = JsonUtils.fromJson(json, FeatureSettings.class);
        if (settings.getPercent() == null) {
            settings.setPercent(0);
        }
        if (settings.getIsAccessibleAfterDisabling() == null) {
            settings.setIsAccessibleAfterDisabling(false);
        }
        if (settings.getRoles() == null) {
            settings.setRoles(emptySet());
        }
        if (settings.getIsPublic() == null) {
            settings.setIsPublic(false);
        }
        return settings;
    }
}
