package ru.yandex.direct.core.entity.feature.service.validation;

import java.util.List;
import java.util.Map;
import java.util.Set;

import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Service
public class ClientIdValidationService {
    private final ShardHelper shardHelper;

    @Autowired
    public ClientIdValidationService(ShardHelper shardHelper) {
        this.shardHelper = shardHelper;
    }

    public ValidationResult<List<ClientId>, Defect> validate(List<ClientId> clientIds) {
        Map<Long, Boolean> existingClientMap = shardHelper.getExistingClientIds(mapList(clientIds, ClientId::asLong));
        Set<ClientId> existingClientIds = EntryStream.of(existingClientMap)
                .filterKeyValue((clientId, state) -> state)
                .keys().map(ClientId::fromLong).toSet();
        ListValidationBuilder<ClientId, Defect> lvb = ListValidationBuilder.of(clientIds);

        lvb.checkEach(inSet(existingClientIds));

        return lvb.getResult();
    }
}
