package ru.yandex.direct.core.entity.feature.service.validation;

import java.util.List;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.feature.model.Feature;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

@Service
public class FeatureAddValidationService {
    public ValidationResult<List<Feature>, Defect> validate(List<Feature> featureList) {
        ListValidationBuilder<Feature, Defect> lvb = ListValidationBuilder.of(featureList);
        lvb.checkEachBy(this::validateFeature);
        return lvb.getResult();
    }

    private ValidationResult<Feature, Defect> validateFeature(Feature feature) {
        ModelItemValidationBuilder<Feature> vb = ModelItemValidationBuilder.of(feature);
        vb.item(Feature.FEATURE_TEXT_ID)
                .check(notNull())
                .check(notBlank(), When.isValid());
        vb.item(Feature.FEATURE_PUBLIC_NAME)
                .check(notNull())
                .check(notBlank(), When.isValid());
        return vb.getResult();
    }
}
