package ru.yandex.direct.core.entity.feature.service.validation;

import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Service
public class FeatureTextIdValidationService {
    public ValidationResult<List<String>, Defect> validate(Set<String> featureTextIds,
                                                           List<String> featuresTextIds) {
        return ListValidationBuilder.<String, Defect>of(featuresTextIds)
                .checkEach(inSet(featureTextIds))
                .getResult();
    }

    public ValidationResult<String, Defect> validate(Set<String> sourceFeatureTextIds, String featureTextId) {
        return ModelItemValidationBuilder.<String, Defect>of(featureTextId)
                .check(inSet(sourceFeatureTextIds))
                .getResult();
    }
}
