package ru.yandex.direct.core.entity.feature.service.validation;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.feature.container.FeatureTextIdToLoginState;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Service
public class SwitchFeatureByLoginValidationService {
    public ValidationResult<String, Defect> validateFeatureIds(List<String> featureIds,
                                                               Set<String> featureTextIds) {
        ItemValidationBuilder<String, Defect> v = ItemValidationBuilder.of(StringUtils.EMPTY);
        v.list(featureIds, "feature_ids")
                .checkEach(inSet(featureTextIds));
        return v.getResult();
    }

    public ValidationResult<List<FeatureTextIdToLoginState>, Defect> validate(
            List<FeatureTextIdToLoginState> switchFeatureToClientList, Map<String, Long> clientIdsByLogins) {
        ListValidationBuilder<FeatureTextIdToLoginState, Defect> lvb =
                ListValidationBuilder.of(switchFeatureToClientList);
        lvb.checkEachBy(featureToUid -> validateFeatureToClient(featureToUid,
                        clientIdsByLogins.keySet()));
        return lvb.getResult();
    }

    public ValidationResult<List<String>, Defect> validateLogins(
            Map<String, Long> clientIdsByLogins, List<String> logins
    ) {
        var existingLogins = clientIdsByLogins.keySet();
        return ListValidationBuilder.<String, Defect>of(logins)
                .checkEachBy(login -> validateLogin(login, existingLogins))
                .getResult();
    }

    private ValidationResult<String, Defect> validateLogin(String login, Set<String> existingLogins) {
        var vb = ItemValidationBuilder.<String, Defect>of(login);
        vb.item(login, "login")
                .check(inSet(existingLogins));
        return vb.getResult();
    }

    private ValidationResult<FeatureTextIdToLoginState, Defect> validateFeatureToClient(
            FeatureTextIdToLoginState featureTextIdToLoginState,
            Set<String> existedClientLogins) {
        ItemValidationBuilder<FeatureTextIdToLoginState, Defect> vb =
                ItemValidationBuilder.of(featureTextIdToLoginState);
        vb.item(featureTextIdToLoginState.getLogin(), FeatureTextIdToLoginState.LOGIN.name())
                .check(inSet(existedClientLogins));
        return vb.getResult();
    }
}
