package ru.yandex.direct.core.entity.feed;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

/**
 * Здесь переводы для сервиса фидов для всего, кроме ошибок и предупреждений
 * <p>
 * Переводы дефектов в {@link ru.yandex.direct.core.entity.feed.validation.FeedDefectTranslations}
 */
@ParametersAreNonnullByDefault
public interface FeedTranslations extends TranslationBundle {

    FeedTranslations INSTANCE = I18NBundle.implement(FeedTranslations.class);

    @TranslationStub("Ручное управление товарами")
    Translatable manualFeedName();

}
