package ru.yandex.direct.core.entity.feed.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.Source;
import ru.yandex.direct.core.entity.feed.model.UpdateStatus;
import ru.yandex.direct.dbutil.model.BusinessIdAndShopId;
import ru.yandex.direct.multitype.entity.LimitOffset;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

/**
 * Контейнер для правил, применяемых при отборе фидов
 */
public class FeedQueryFilter {
    private final List<Long> feedIds;
    private final List<BusinessIdAndShopId> businessIdsAndShopIds;
    private final List<UpdateStatus> updateStatuses;
    private final List<Source> sources;
    private final List<FeedsOrderBy> orders;
    private final List<BusinessType> types;
    private final List<String> names;
    private final List<String> targetDomains;
    private final String searchBy;
    private final LimitOffset limitOffset;

    private FeedQueryFilter(Builder builder) {
        feedIds = builder.feedIds;
        businessIdsAndShopIds = builder.businessIdsAndShopIds;
        updateStatuses = builder.updateStatuses;
        sources = builder.sources;
        orders = builder.orders;
        types = builder.types;
        names = builder.names;
        targetDomains = builder.targetDomains;
        searchBy = builder.searchBy;
        limitOffset = builder.limitOffset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Nullable
    public List<Long> getFeedIds() {
        return feedIds;
    }

    @Nullable
    public List<BusinessIdAndShopId> getBusinessIdsAndShopIds() {
        return businessIdsAndShopIds;
    }

    @Nullable
    public List<UpdateStatus> getUpdateStatuses() {
        return updateStatuses;
    }

    @Nullable
    public List<Source> getSources() {
        return sources;
    }

    @Nullable
    public List<FeedsOrderBy> getOrders() {
        return orders;
    }

    @Nullable
    public List<BusinessType> getTypes() {
        return types;
    }

    @Nullable
    public List<String> getNames() {
        return names;
    }

    @Nullable
    public List<String> getTargetDomains() {
        return targetDomains;
    }

    @Nullable
    public String getSearchBy() {
        return searchBy;
    }

    @Nullable
    public LimitOffset getLimitOffset() {
        return limitOffset;
    }

    @SuppressWarnings("UnusedReturnValue")
    public static class Builder {

        private List<Long> feedIds = null;
        private List<BusinessIdAndShopId> businessIdsAndShopIds = null;
        private List<UpdateStatus> updateStatuses = null;
        private List<Source> sources = null;
        private List<FeedsOrderBy> orders = null;
        private List<BusinessType> types = null;
        private List<String> names = null;
        private List<String> targetDomains = null;
        private String searchBy = null;
        private LimitOffset limitOffset = null;

        private Builder() {
        }

        public Builder withFeedIds(@Nullable Collection<Long> feedIds) {
            this.feedIds = ifNotNull(feedIds, ArrayList::new);
            return this;
        }

        public Builder withBusinessIdsAndShopIds(@Nullable Collection<BusinessIdAndShopId> businessIdsAndShopIds) {
            this.businessIdsAndShopIds = businessIdsAndShopIds != null ? new ArrayList<>(businessIdsAndShopIds) : null;
            return this;
        }

        public Builder withUpdateStatuses(@Nullable Collection<UpdateStatus> updateStatuses) {
            this.updateStatuses = updateStatuses != null ? new ArrayList<>(updateStatuses) : null;
            return this;
        }

        public Builder withSources(@Nullable Collection<Source> sources) {
            this.sources = sources != null ? new ArrayList<>(sources) : null;
            return this;
        }

        public Builder withOrders(@Nullable List<FeedsOrderBy> orders) {
            this.orders = orders != null ? new ArrayList<>(orders) : null;
            return this;
        }

        public Builder withTypes(@Nullable List<BusinessType> types) {
            this.types = types != null ? new ArrayList<>(types) : null;
            return this;
        }

        public Builder withNames(@Nullable List<String> names) {
            this.names = names != null ? new ArrayList<>(names) : null;
            return this;
        }

        public Builder withTargetDomains(@Nullable List<String> targetDomains) {
            this.targetDomains = targetDomains != null ? new ArrayList<>(targetDomains) : null;
            return this;
        }

        public Builder withSearchBy(@Nullable String searchBy) {
            this.searchBy = searchBy;
            return this;
        }

        public Builder withLimitOffset(@Nullable LimitOffset limitOffset) {
            this.limitOffset = limitOffset;
            return this;
        }

        public FeedQueryFilter build() {
            return new FeedQueryFilter(this);
        }
    }
}
