package ru.yandex.direct.core.entity.feed.model

import java.sql.ResultSet

data class FeedRow(
    val clientId: Long,
    val feedId: Long,
    val businessId: Long,
    val shopId: Long,
    val url: String,
    val login: String?,
    val password: String?,
    val shopName: String
) {
    companion object {
        private const val CLIENT_ID = "client_id"
        private const val FEED_ID = "feed_id"
        private const val BUSINESS_ID = "business_id"
        private const val SHOP_ID = "shop_id"
        private const val URL = "url"
        private const val LOGIN = "http_login"
        private const val PASSWORD = "http_password"
        private const val SHOP_NAME = "shop_name"

        fun fromResultSet(rs: ResultSet): FeedRow {
            return FeedRow(
                rs.getLong(CLIENT_ID),
                rs.getLong(FEED_ID),
                rs.getLong(BUSINESS_ID),
                rs.getLong(SHOP_ID),
                rs.getString(URL),
                rs.getString(LOGIN),
                rs.getString(PASSWORD),
                rs.getString(SHOP_NAME)
            )
        }
    }
}
