package ru.yandex.direct.core.entity.feed.repository

import org.springframework.stereotype.Repository
import ru.yandex.direct.dbutil.model.BusinessIdAndShopId
import ru.yandex.direct.grid.schema.yt.Tables.FEED_TO_TASKS_DYN
import ru.yandex.direct.grid.schema.yt.Tables.FEED_TO_TASKS_PERF
import ru.yandex.direct.ytcomponents.service.BlrtDynContextProvider

@Repository
class BlrtYtRepository(
    private val dynContextProvider: BlrtDynContextProvider
) {
    fun getDynamicTasksBusinessIdsAndShopIds() =
        dynContextProvider.context
            .readTable(FEED_TO_TASKS_DYN, listOf(FEED_TO_TASKS_DYN.BUSINESS_ID, FEED_TO_TASKS_DYN.SHOP_ID))
            .map { BusinessIdAndShopId.of(
                it.getLong(FEED_TO_TASKS_DYN.BUSINESS_ID.name),
                it.getLong(FEED_TO_TASKS_DYN.SHOP_ID.name)
            ) }

    fun getPerformanceTasksBusinessIdsAndShopIds() =
        dynContextProvider.context
            .readTable(FEED_TO_TASKS_PERF, listOf(FEED_TO_TASKS_PERF.BUSINESS_ID, FEED_TO_TASKS_PERF.SHOP_ID))
            .map { BusinessIdAndShopId.of(
                it.getLong(FEED_TO_TASKS_PERF.BUSINESS_ID.name),
                it.getLong(FEED_TO_TASKS_PERF.SHOP_ID.name)
            ) }
}
