package ru.yandex.direct.core.entity.feed.repository

import org.springframework.stereotype.Repository
import ru.yandex.direct.core.entity.feed.model.FeedRow
import ru.yandex.direct.ytwrapper.client.YtExecutionUtil.executeWithFallback
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtOperator
import ru.yandex.misc.io.ClassPathResourceInputStreamSource

@Repository
class DataCampFeedYtRepository(
    private val ytProvider: YtProvider,
    private val marketFeedsConfig: MarketFeedsConfig
) {
    companion object {
        private val MARKET_FEEDS_FETCH_QUERY =
            ClassPathResourceInputStreamSource("feed/getMarketFeedsToSync.yql")
                .readLines()
                .joinToString("\n")

        private const val FETCH_SIZE = 100_000L
    }

    fun getYtFeedsRows(clientIds: Set<Long>): List<FeedRow> {
        val ytClusters = marketFeedsConfig.clusters
        val ytDataCampFeedsTablePath = marketFeedsConfig.ytDataCampFeedsTablePath
        val ytShopNamesTablePath = marketFeedsConfig.ytShopNamesTablePath

        return executeWithFallback(ytClusters, ytProvider::getOperator) { ytOperator: YtOperator ->
            ytOperator.yqlQuery(
                MARKET_FEEDS_FETCH_QUERY,
                FeedRow::fromResultSet,
                ytDataCampFeedsTablePath,
                ytShopNamesTablePath,
                FETCH_SIZE
            )
                .filter { clientIds.contains(it.clientId) }
        }
    }
}
