package ru.yandex.direct.core.entity.feed.repository;

import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.FeedUsageType;
import ru.yandex.direct.core.entity.feed.model.MasterSystem;
import ru.yandex.direct.core.entity.feed.model.StatusMBIEnabled;
import ru.yandex.direct.core.entity.feed.model.StatusMBISynced;
import ru.yandex.direct.core.entity.feed.model.UpdateStatus;
import ru.yandex.direct.dbschema.ppc.enums.FeedsBusinessType;
import ru.yandex.direct.dbschema.ppc.enums.FeedsMasterSystem;
import ru.yandex.direct.dbschema.ppc.enums.FeedsStatusmbienabled;
import ru.yandex.direct.dbschema.ppc.enums.FeedsStatusmbisynced;
import ru.yandex.direct.dbschema.ppc.enums.FeedsUpdateStatus;

import static ru.yandex.direct.common.util.RepositoryUtils.enumSetReader;
import static ru.yandex.direct.utils.CommonUtils.nvl;

public class FeedMappings {

    public static FeedsBusinessType toBusinessType(BusinessType value) {
        return value == null ? FeedsBusinessType.retail : BusinessType.toSource(value);
    }

    public static Long toIsRemoveUtm(Boolean value) {
        return value == null ? 0L : RepositoryUtils.booleanToLong(value);
    }

    public static FeedsUpdateStatus toUpdateStatus(UpdateStatus value) {
        return value == null ? FeedsUpdateStatus.New : UpdateStatus.toSource(value);
    }

    public static FeedsMasterSystem toMasterSystem(MasterSystem value) {
        return value == null ? FeedsMasterSystem.direct : MasterSystem.toSource(value);
    }

    public static FeedsStatusmbisynced toStatusMbiSynced(StatusMBISynced value) {
        return value == null ? FeedsStatusmbisynced.No : StatusMBISynced.toSource(value);
    }

    public static FeedsStatusmbienabled toStatusMbiEnabled(StatusMBIEnabled value) {
        return value == null ? FeedsStatusmbienabled.No : StatusMBIEnabled.toSource(value);
    }

    static String feedUsageTypeToDbFormat(Collection<FeedUsageType> feedUsageTypes) {
        return nvl(feedUsageTypes, EnumSet.noneOf(FeedUsageType.class))
                .stream()
                .map(FeedUsageType::getTypedValue)
                .collect(Collectors.joining(","));
    }

    static EnumSet<FeedUsageType> feedUsageTypeFromDbFormat(String feedUsageTypes) {
        return (EnumSet<FeedUsageType>) enumSetReader(FeedUsageType.class, FeedUsageType::fromTypedValue)
                .read(feedUsageTypes);
    }

}
