package ru.yandex.direct.core.entity.feed.repository

import org.springframework.stereotype.Component
import ru.yandex.direct.config.DirectConfig
import ru.yandex.direct.ytwrapper.model.YtCluster

@Component
class MarketFeedsConfig(
    directConfig: DirectConfig
) {
    private val config = directConfig.getBranch("market_feeds")

    val clusters: List<YtCluster>
        get() = config.getStringList("clusters").map {
            YtCluster.valueOf(it.uppercase())
        }

    val ytDataCampFeedsTablePath: String
        get() = config.getString("dc_feeds_table")

    val ytShopNamesTablePath: String
        get() = config.getString("feed_names_table")
}
