package ru.yandex.direct.core.entity.feed.service;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.feed.UploadedToMdsFeedInformation;
import ru.yandex.direct.core.entity.mdsfile.model.MdsFileMetadata;
import ru.yandex.direct.core.entity.mdsfile.model.MdsFileSaveRequest;
import ru.yandex.direct.core.entity.mdsfile.model.MdsStorageType;
import ru.yandex.direct.core.entity.mdsfile.service.MdsFileService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.utils.HashingUtils;

@Service
public class FeedUploaderService {

    private final MdsFileService mdsFileService;

    @Autowired
    public FeedUploaderService(MdsFileService mdsFileService) {
        this.mdsFileService = mdsFileService;
    }

    public UploadedToMdsFeedInformation uploadToMds(ClientId clientId, byte[] data) {
        String hash = HashingUtils.getMd5HashAsBase64YaStringWithoutPadding(data);
        Map<String, MdsFileMetadata> metaData = mdsFileService.getMetaData(clientId, List.of(hash));
        MdsFileMetadata mdsSavedFileMetadata = metaData.get(hash);
        if (mdsSavedFileMetadata != null) {
            mdsFileService.updateCreateTime(clientId, mdsSavedFileMetadata.getId());
            String url = mdsFileService.getUrl(mdsSavedFileMetadata);
            return new UploadedToMdsFeedInformation()
                    .withUrl(url)
                    .withFileHash(hash);
        }
        String pathPrefix = buildPrefixPathToMds(clientId);
        var mdsFileSaveRequest = new MdsFileSaveRequest(MdsStorageType.PERF_FEEDS, data, hash, pathPrefix);
        mdsFileService.saveMdsFiles(List.of(mdsFileSaveRequest), clientId.asLong());
        String url = mdsFileService.getUrl(mdsFileSaveRequest);
        return new UploadedToMdsFeedInformation()
                .withUrl(url)
                .withFileHash(hash);
    }

    private String buildPrefixPathToMds(ClientId clientId) {
        return MdsStorageType.PERF_FEEDS.name().toLowerCase() + "/" + clientId;
    }
}
