package ru.yandex.direct.core.entity.feed.validation;

import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class FeedDefectIds {

    public enum Gen implements DefectId<Void> {
        FEED_IS_NOT_SET,
        FEED_ID_IS_NOT_VALID,
        FEED_USED_IN_AD_GROUP,
        FEED_INVALID_HREF,
        FEED_NAME_CANNOT_BE_EMPTY,
        FEED_LOGIN_CANNOT_BE_EMPTY,
        FEED_PASSWORD_CANNOT_BE_EMPTY,
        FEED_INVALID_FILENAME,
        FEED_INCONSISTENT_TYPE_FOR_UPDATE,
        FEED_NOT_EXIST,
        FEED_LOGIN_IS_NOT_SET,
        FEED_PASSWORD_IS_NOT_SET,
        FEED_APART_RESET_LOGIN_AND_PASSWORD,
        FEED_WITHOUT_URL_SOURCE_CANNOT_BE_REFRESHED,
        FEED_WITH_STATUS_NEW_CANNOT_BE_REFRESHED,
        FEED_IS_USED_IN_CAMPAIGN_BRIEF,
    }

    public enum String implements DefectId<StringDefectParams> {
        FEED_NAME_FIELD_IS_TOO_LONG,
        FEED_BODY_FIELD_IS_TOO_LONG,
        FEED_STATUS_WRONG,
        FEED_BY_SITE_CONTAINS_DUPLICATED_URL,
        FEED_BY_SITE_FOR_NOT_ALLOWED_URL,
        FEED_BY_SITE_FOR_NOT_DOMAIN_ONLY_URL
    }

    public enum ModelId implements DefectId<ModelIdDefectParams> {
        FEED_BY_SITE_WITH_SAME_DOMAIN_ALREADY_EXISTS
    }

    public enum Number implements DefectId<NumberDefectParams> {
        FEED_CANNOT_BE_REFRESHED_MORE_OFTEN_THAN_REFRESH_HOURS_PERIOD
    }
}
