package ru.yandex.direct.core.entity.feed.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;

public interface FeedDefectTranslations extends TranslationBundle {

    FeedDefectTranslations INSTANCE = I18NBundle.implement(FeedDefectTranslations.class);

    @MessageFormatStub("Не задан фид")
    Translatable feedIsNotSetDetailed();

    @MessageFormatStub("Недопустимый формат идентификатора фида")
    Translatable feedIdIsNotValidDetailed();

    @MessageFormatStub("Фид используется в группе объявлений и не может быть удален")
    Translatable feedUsedInAdGroupDetailed();

    @MessageFormatStub("Операция не может быть выполнена для фида со статусом '{0}'")
    Translatable feedStatusWrongDetailed(String status);

    @MessageFormatStub("Задано слишком длинное название поля фида, которое должно подставляться в качестве заголовка " +
            "объявления. Максимальное количество символов: {0}")
    Translatable feedNameFieldIsTooLongDetailed(Identity maxLength);

    @MessageFormatStub("Задано слишком длинное название поля фида, которое должно подставляться в качестве текста " +
            "объявления. Максимальное количество символов: {0}")
    Translatable feedBodyFieldIsTooLongDetailed(Identity maxLength);

    @MessageFormatStub("Неправильный формат ссылки")
    Translatable feedInvalidHrefDetailed();

    @MessageFormatStub("Название фида не может быть пустой строкой \"\"")
    Translatable feedNameCannotBeEmptyDetailed();

    @MessageFormatStub("Логин для доступа к фиду не может быть пустой строкой \"\"")
    Translatable feedLoginCannotBeEmptyDetailed();

    @MessageFormatStub("Пароль для доступа к фиду не может быть пустой строкой \"\"")
    Translatable feedPasswordCannotBeEmptyDetailed();

    @MessageFormatStub("Недопустимое расширение файла")
    Translatable feedInvalidFilenameDetailed();

    @MessageFormatStub("Параметры фида не соответствуют указанному типу источника данных")
    Translatable feedInconsistentTypeDetailed();

    @MessageFormatStub("Фид не найден")
    Translatable feedNotExistDetailed();

    @MessageFormatStub("Не задан логин для доступа к фиду")
    Translatable feedLoginIsNotSetDetailed();

    @MessageFormatStub("Не задан пароль для доступа к фиду")
    Translatable feedPasswordIsNotSetDetailed();

    @MessageFormatStub("Логин и пароль для доступа к фиду должны быть сброшены одновременно")
    Translatable feedApartResetLoginAnPasswordDetailed();

    @MessageFormatStub("Домены в запросе для создания фидов по сайту должны отличаться. Повторяющийся сайт: {0}")
    Translatable feedBySiteContainsDuplicatedUrlDetailed(String url);

    @MessageFormatStub("Для домена запрещено создавать фид по сайту: {0}")
    Translatable feedBySiteForNotAllowedUrl(String url);

    @MessageFormatStub("Фид по сайту можно создавать только по домену целиком, поэтому вместо {0}, будет подставлено " +
            "{1}")
    Translatable feedBySiteForNotDomainOnlyUrl(String baseUrl, String domainOnlyUrl);

    @MessageFormatStub("Фид по сайту с данным доменом уже существует. Id существующего фида: {0}")
    Translatable feedBySiteWithSameDomainAlreadyExistsDetailed(Identity feedId);

    @MessageFormatStub("Фид был обновлен менее {0} часов назад")
    Translatable feedCannotBeRefreshedMoreOftenThanRefreshHoursPeriod(long min);

    @MessageFormatStub("Обновление доступно только для фидов, загружаемых по ссылке")
    Translatable feedWithoutUrlSourceCannotBeRefreshed();

    @MessageFormatStub("Обновление недоступно для недавно созданных или обновленных фидов")
    Translatable feedWithStatusNewCannotBeRefreshed();

    @MessageFormatStub("Невозможно удалить фид, используемый в кампаниях")
    Translatable feedIsUsedInCampaignBrief();
}
