package ru.yandex.direct.core.entity.feed.validation;

import java.util.List;

import ru.yandex.direct.core.entity.feed.model.UpdateStatus;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.Defect;

import static java.util.Collections.singletonList;

public class FeedDefects {
    private FeedDefects() {
    }

    public static Defect feedIsNotSet() {
        return new Defect<>(FeedDefectIds.Gen.FEED_IS_NOT_SET);
    }

    public static Defect feedIdIsNotValid() {
        return new Defect<>(FeedDefectIds.Gen.FEED_ID_IS_NOT_VALID);
    }

    public static Defect feedUsedInAdGroup() {
        return new Defect<>(FeedDefectIds.Gen.FEED_USED_IN_AD_GROUP);
    }

    public static Defect feedInvalidHref() {
        return new Defect<>(FeedDefectIds.Gen.FEED_INVALID_HREF);
    }

    public static Defect feedNameCannotBeEmpty() {
        return new Defect<>(FeedDefectIds.Gen.FEED_NAME_CANNOT_BE_EMPTY);
    }

    public static Defect feedLoginCannotBeEmpty() {
        return new Defect<>(FeedDefectIds.Gen.FEED_LOGIN_CANNOT_BE_EMPTY);
    }

    public static Defect feedPasswordCannotBeEmpty() {
        return new Defect<>(FeedDefectIds.Gen.FEED_PASSWORD_CANNOT_BE_EMPTY);
    }

    public static Defect feedInvalidFilename() {
        return new Defect<>(FeedDefectIds.Gen.FEED_INVALID_FILENAME);
    }

    public static Defect feedInconsistentTypeForUpdate() {
        return new Defect<>(FeedDefectIds.Gen.FEED_INCONSISTENT_TYPE_FOR_UPDATE);
    }

    public static Defect feedNotExist() {
        return new Defect<>(FeedDefectIds.Gen.FEED_NOT_EXIST);
    }

    public static Defect feedLoginIsNotSet() {
        return new Defect<>(FeedDefectIds.Gen.FEED_LOGIN_IS_NOT_SET);
    }

    public static Defect feedPasswordIsNotSet() {
        return new Defect<>(FeedDefectIds.Gen.FEED_PASSWORD_IS_NOT_SET);
    }

    public static Defect feedApartResetLoginAnPassword() {
        return new Defect<>(FeedDefectIds.Gen.FEED_APART_RESET_LOGIN_AND_PASSWORD);
    }

    public static Defect<StringDefectParams> feedStatusWrong(UpdateStatus updateStatus) {
        return new Defect<>(FeedDefectIds.String.FEED_STATUS_WRONG,
                new StringDefectParams().withInvalidSubstrings(singletonList(updateStatus.name())));
    }

    public static Defect feedNameFieldIsTooLong(int maxLength) {
        return new Defect<>(FeedDefectIds.String.FEED_NAME_FIELD_IS_TOO_LONG,
                new StringDefectParams().withMaxLength(maxLength));
    }

    public static Defect feedBodyFieldIsTooLong(int maxLength) {
        return new Defect<>(FeedDefectIds.String.FEED_BODY_FIELD_IS_TOO_LONG,
                new StringDefectParams().withMaxLength(maxLength));
    }

    public static Defect feedBySiteContainsDuplicatedUrl(String url) {
        return new Defect<>(FeedDefectIds.String.FEED_BY_SITE_CONTAINS_DUPLICATED_URL,
                new StringDefectParams().withInvalidSubstrings(List.of(url)));
    }

    public static Defect feedBySiteForNotAllowedUrl(String url) {
        return new Defect<>(FeedDefectIds.String.FEED_BY_SITE_FOR_NOT_ALLOWED_URL,
                new StringDefectParams().withInvalidSubstrings(List.of(url)));
    }

    public static Defect feedBySiteForNotDomainOnlyUrl(String baseUrl, String domainOnlyUrl) {
        return new Defect<>(FeedDefectIds.String.FEED_BY_SITE_FOR_NOT_DOMAIN_ONLY_URL,
                new StringDefectParams().withInvalidSubstrings(List.of(baseUrl, domainOnlyUrl)));
    }

    public static Defect feedBySiteWithSameDomainAlreadyExists(long feedId) {
        return new Defect<>(FeedDefectIds.ModelId.FEED_BY_SITE_WITH_SAME_DOMAIN_ALREADY_EXISTS,
                new ModelIdDefectParams().withId(feedId));
    }

    public static Defect feedCannotBeRefreshedMoreOftenThanRefreshHoursPeriod(long min) {
        return new Defect<>(FeedDefectIds.Number.FEED_CANNOT_BE_REFRESHED_MORE_OFTEN_THAN_REFRESH_HOURS_PERIOD,
                new NumberDefectParams().withMin(min));
    }

    public static Defect feedWithoutUrlSourceCannotBeRefreshed() {
        return new Defect<>(FeedDefectIds.Gen.FEED_WITHOUT_URL_SOURCE_CANNOT_BE_REFRESHED);
    }

    public static Defect feedWithStatusNewCannotBeRefreshed() {
        return new Defect<>(FeedDefectIds.Gen.FEED_WITH_STATUS_NEW_CANNOT_BE_REFRESHED);
    }

    public static Defect feedIsUsedInCampaignBrief() {
        return new Defect<>(FeedDefectIds.Gen.FEED_IS_USED_IN_CAMPAIGN_BRIEF);
    }
}
