package ru.yandex.direct.core.entity.feedfilter.converter

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonSubTypes
import com.fasterxml.jackson.annotation.JsonTypeInfo
import com.fasterxml.jackson.annotation.JsonValue
import ru.yandex.direct.core.entity.performancefilter.container.DecimalRange
import ru.yandex.direct.core.entity.performancefilter.container.Exists

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(
    JsonSubTypes.Type(FeedFilterConditionValue.BooleanV::class, name = FeedFilterConditionValue.BOOLEAN_TYPE),
    JsonSubTypes.Type(FeedFilterConditionValue.ExistsV::class, name = FeedFilterConditionValue.EXISTS_TYPE),
    JsonSubTypes.Type(FeedFilterConditionValue.LongList::class, name = FeedFilterConditionValue.LONG_LIST_TYPE),
    JsonSubTypes.Type(FeedFilterConditionValue.StringList::class, name = FeedFilterConditionValue.STRING_LIST_TYPE),
    JsonSubTypes.Type(FeedFilterConditionValue.DoubleList::class, name = FeedFilterConditionValue.DOUBLE_LIST_TYPE),
    JsonSubTypes.Type(FeedFilterConditionValue.DecimalRangeList::class, name = FeedFilterConditionValue.DECIMAL_RANGE_LIST_TYPE),
    JsonSubTypes.Type(FeedFilterConditionValue.EmptyList::class, name = FeedFilterConditionValue.EMPTY_LIST_TYPE)
)
sealed class FeedFilterConditionValue {

    abstract val parsedValue: Any

    fun toObject(): Any = parsedValue

    data class BooleanV @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    constructor(@JsonValue override val parsedValue: Boolean) : FeedFilterConditionValue()

    data class ExistsV @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    constructor(@JsonValue override val parsedValue: Exists) : FeedFilterConditionValue()

    data class LongList @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    constructor(@JsonValue override val parsedValue: List<Long>) : FeedFilterConditionValue()

    data class StringList @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    constructor(@JsonValue override val parsedValue: List<String>) : FeedFilterConditionValue()

    data class DoubleList @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    constructor(@JsonValue override val parsedValue: List<Double>) : FeedFilterConditionValue()

    data class DecimalRangeList @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    constructor(@JsonValue override val parsedValue: List<DecimalRange>) : FeedFilterConditionValue()

    class EmptyList @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    constructor(@JsonValue override val parsedValue: List<Nothing>) : FeedFilterConditionValue()

    companion object {
        @JvmStatic
        fun fromObject(value: Any): FeedFilterConditionValue = when (value) {
            is Boolean -> BooleanV(value)
            is Exists -> ExistsV(value)
            is List<*> -> when (value.firstOrNull()) {
                is Long -> LongList(value.map { it as Long })
                is String -> StringList(value.map { it as String })
                is Double -> DoubleList(value.map { it as Double })
                is DecimalRange -> DecimalRangeList(value.map { it as DecimalRange })
                null -> EmptyList(listOf())
                else -> unsupportedTypeError()
            }
            else -> unsupportedTypeError()
        }

        private fun unsupportedTypeError(): Nothing {
            throw IllegalArgumentException("Field value is of an unsupported type")
        }

        const val BOOLEAN_TYPE = "bool"
        const val EXISTS_TYPE = "exists"
        const val LONG_LIST_TYPE = "[long]"
        const val STRING_LIST_TYPE = "[str]"
        const val DOUBLE_LIST_TYPE = "[double]"
        const val DECIMAL_RANGE_LIST_TYPE = "[range]"
        const val EMPTY_LIST_TYPE = "[]"
    }
}
