package ru.yandex.direct.core.entity.feedfilter.service

import ru.yandex.direct.core.entity.feedfilter.model.FeedFilterCondition
import ru.yandex.direct.core.entity.performancefilter.model.Operator

class ParsedFeedFilterConditionAutoSerializingFactory(private val fieldValueSerializer: FeedFilterFieldValueSerializer) :
    ParsedFeedFilterConditionFactory {
    override fun <V> create(fieldName: String, operator: Operator, value: V): FeedFilterCondition<V> =
        FeedFilterCondition<V>(fieldName, operator, fieldValueSerializer.serializeFeedFilterFieldValue(value))
            .withParsedValue(value)
}
