package ru.yandex.direct.core.entity.feedfilter.service

import com.fasterxml.jackson.core.JsonProcessingException
import com.fasterxml.jackson.databind.ObjectMapper
import ru.yandex.direct.core.entity.feedfilter.model.FeedFilter

class FeedFilterByMapperSerializer(mapper: ObjectMapper) : FeedFilterSerializer {
    private val serializer = ByMapperSerializer(mapper, "filter")
    override fun serializeFeedFilter(feedFilter: FeedFilter): String = serializer.serialize(feedFilter)
}

class FeedFilterFieldValueByMapperSerializer(mapper: ObjectMapper) : FeedFilterFieldValueSerializer {
    private val serializer = ByMapperSerializer(mapper, "field value")
    override fun <V> serializeFeedFilterFieldValue(fieldValue: V): String = serializer.serialize(fieldValue)
}

private open class ByMapperSerializer(private val mapper: ObjectMapper, private val what: String) {
    fun <T> serialize(value: T): String =
        try {
            mapper.writeValueAsString(value)
        } catch (e: JsonProcessingException) {
            throw IllegalArgumentException("cannot serialize $what", e)
        }
}

class FeedFilterByMapperDeserializer(private val mapper: ObjectMapper) : FeedFilterDeserializer {
    override fun deserializeFeedFilter(feedFilterRepresentation: String): FeedFilter =
        mapper.readValue(feedFilterRepresentation, FeedFilter::class.java)
}

class FeedFilterByMapperConverter(private val mapper: ObjectMapper) :
    FeedFilterSerializer by FeedFilterByMapperSerializer(mapper),
    FeedFilterDeserializer by FeedFilterByMapperDeserializer(mapper),
    FeedFilterConverter
