package ru.yandex.direct.core.entity.feedfilter.validation

import ru.yandex.direct.core.entity.feedfilter.model.FeedFilter
import ru.yandex.direct.core.entity.feedfilter.model.FeedFilterTab
import ru.yandex.direct.core.entity.feedfilter.model.FeedFilterCondition
import ru.yandex.direct.core.entity.performancefilter.schema.FilterSchema
import ru.yandex.direct.core.entity.performancefilter.validation.FilterConditionsValidator
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

class FeedFilterValidator(private val filterSchema: FilterSchema) : Validator<FeedFilter, Defect<Any>> {
    override fun apply(feedFilter: FeedFilter): ValidationResult<FeedFilter, Defect<Any>> =
        ModelItemValidationBuilder.of(feedFilter).apply {
            item(FeedFilter.CONDITIONS).apply {
                checkBy(filterConditionsValidator(filterSchema, feedFilter.tab))
            }
        }.result

    companion object {
        @Suppress("UNCHECKED_CAST")
        private fun filterConditionsValidator(
            filterSchema: FilterSchema,
            filterTab: FeedFilterTab
        ) = FilterConditionsValidator(filterSchema, filterTab) as Validator<List<FeedFilterCondition<*>>, Defect<*>>
    }
}
