package ru.yandex.direct.core.entity.feedoffer.converter;

import ru.yandex.direct.core.entity.feedoffer.model.FeedOffer;
import ru.yandex.direct.core.entity.feedoffer.model.RetailFeedOfferParams;
import ru.yandex.direct.core.grut.model.FeedOfferGrut;
import ru.yandex.direct.core.grut.model.FeedOfferParams;
import ru.yandex.direct.core.grut.model.FeedOfferPrice;

public class FeedOfferConverter {

    private FeedOfferConverter() {
    }

    public static FeedOffer fromFeedOfferGrut(FeedOfferGrut offer) {
        var offerParams = (FeedOfferParams.Retail) offer.getOfferParams();

        return new FeedOffer()
                .withId(offer.getId())
                .withClientId(offer.getClientId())
                .withLabel(offer.getLabel())
                .withDescription(offer.getDescription())
                .withHref(offer.getHref())
                .withImages(offer.getImages())
                .withCurrency(offer.getCurrencyCode())
                .withCurrentPrice(offer.getPrice().getCurrentPrice())
                .withOldPrice(offer.getPrice().getOldPrice())
                .withIsAvailable(offer.isAvailable())
                .withUpdateTime(offer.getUpdateTime())
                .withRetailFeedOfferParams(fromRetailParamsGrut(offerParams));
    }

    private static RetailFeedOfferParams fromRetailParamsGrut(FeedOfferParams.Retail params) {
        return new RetailFeedOfferParams()
                .withCategory(params.getCategory())
                .withVendor(params.getVendor())
                .withModel(params.getModel());
    }

    public static FeedOfferGrut toFeedOfferGrut(FeedOffer offer) {
        return new FeedOfferGrut(
                offer.getId(),
                offer.getClientId(),
                offer.getLabel(),
                offer.getDescription(),
                offer.getHref(),
                offer.getImages(),
                offer.getCurrency(),
                new FeedOfferPrice(
                        offer.getCurrentPrice(),
                        offer.getOldPrice()
                ),
                offer.getIsAvailable(),
                offer.getUpdateTime(),
                toRetalParamsGrut(offer.getRetailFeedOfferParams())
        );
    }

    private static FeedOfferParams.Retail toRetalParamsGrut(RetailFeedOfferParams params) {
        return new FeedOfferParams.Retail(
                params.getCategory(),
                params.getVendor(),
                params.getModel()
        );
    }
}
