package ru.yandex.direct.core.entity.feedoffer.validation;

import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

public class FeedOfferDefects {

    public enum FeedOfferDefectIds implements DefectId<Void> {
        NO_OFFERS,
        UNKNOWN_OFFER_ID,
        OFFER_ID_NOT_UNIQUE,
        CLIENT_NOT_EXIST_IN_GRUT,
        INVALID_HREF,
        HREF_NOT_UNIQUE,
        NO_IMAGES
    }

    public enum FeedOfferNumberDefectIds implements DefectId<NumberDefectParams> {
        OFFER_COUNT_IS_TOO_LARGE,
        IMAGE_COUNT_IS_TOO_LARGE,
        OLD_PRICE_LESS_OR_EQUAL_THAN_CURRENT
    }

    public static Defect<Void> noOffers() {
        return new Defect<>(FeedOfferDefectIds.NO_OFFERS);
    }

    public static Defect<Void> unknownOfferId() {
        return new Defect<>(FeedOfferDefectIds.UNKNOWN_OFFER_ID);
    }

    public static Defect<Void> offerIdNotUnique() {
        return new Defect<>(FeedOfferDefectIds.OFFER_ID_NOT_UNIQUE);
    }

    public static Defect<Void> clientNotExistInGrut() {
        return new Defect<>(FeedOfferDefectIds.CLIENT_NOT_EXIST_IN_GRUT);
    }

    public static Defect<Void> offerHasInvalidHref() {
        return new Defect<>(FeedOfferDefectIds.INVALID_HREF);
    }

    public static Defect<Void> hrefNotUnique() {
        return new Defect<>(FeedOfferDefectIds.HREF_NOT_UNIQUE);
    }

    public static Defect<Void> noImages() {
        return new Defect<>(FeedOfferDefectIds.NO_IMAGES);
    }

    public static Defect offerCountIsTooLarge(Number max) {
        return new Defect<>(FeedOfferNumberDefectIds.OFFER_COUNT_IS_TOO_LARGE,
                new NumberDefectParams().withMax(max));
    }

    public static Defect imageCountIsTooLarge(Number max) {
        return new Defect<>(FeedOfferNumberDefectIds.IMAGE_COUNT_IS_TOO_LARGE,
                new NumberDefectParams().withMax(max));
    }

    public static Defect oldPriceLessOrEqualThanCurrent(Number min) {
        return new Defect<>(FeedOfferNumberDefectIds.OLD_PRICE_LESS_OR_EQUAL_THAN_CURRENT,
                new NumberDefectParams().withMin(min));
    }
}
