package ru.yandex.direct.core.entity.forecast.model;

import java.math.BigDecimal;

public class CpaEstimatesContainer {

    private BigDecimal medianCpa;
    private BigDecimal minCpa;
    private BigDecimal maxCpa;

    public BigDecimal getMedianCpa() {
        return medianCpa;
    }

    public CpaEstimatesContainer withMedianCpa(BigDecimal medianCpa) {
        this.medianCpa = medianCpa;
        return this;
    }

    public CpaEstimatesContainer withMedianCpa(double medianCpa) {
        this.medianCpa = BigDecimal.valueOf(medianCpa);
        return this;
    }

    public BigDecimal getMinCpa() {
        return minCpa;
    }

    public CpaEstimatesContainer withMinCpa(BigDecimal minCpa) {
        this.minCpa = minCpa;
        return this;
    }

    public CpaEstimatesContainer withMinCpa(double minCpa) {
        this.minCpa = BigDecimal.valueOf(minCpa);
        return this;
    }

    public BigDecimal getMaxCpa() {
        return maxCpa;
    }

    public CpaEstimatesContainer withMaxCpa(BigDecimal maxCpa) {
        this.maxCpa = maxCpa;
        return this;
    }

    public CpaEstimatesContainer withMaxCpa(double maxCpa) {
        this.maxCpa = BigDecimal.valueOf(maxCpa);
        return this;
    }
}
