package ru.yandex.direct.core.entity.freelancer.container;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerProjectStatus;

import static java.util.Arrays.asList;

public class FreelancerProjectQueryContainer {
    private final List<Long> freelancerIds;
    private final List<Long> clientIds;
    private final List<Long> projectIds;
    private final Collection<FreelancerProjectStatus> statuses;
    private final Boolean isStarted;

    private FreelancerProjectQueryContainer(List<Long> freelancerIds,
                                            List<Long> clientIds,
                                            List<Long> projectIds,
                                            Collection<FreelancerProjectStatus> statuses, Boolean isStarted) {
        this.freelancerIds = freelancerIds;
        this.clientIds = clientIds;
        this.projectIds = projectIds;
        this.statuses = statuses;
        this.isStarted = isStarted;
    }

    public List<Long> getFreelancerIds() {
        return freelancerIds;
    }

    public List<Long> getClientIds() {
        return clientIds;
    }

    public List<Long> getProjectIds() {
        return projectIds;
    }

    public Collection<FreelancerProjectStatus> getStatuses() {
        return statuses;
    }

    public Boolean getStarted() {
        return isStarted;
    }

    public boolean hasFreelancerIds() {
        return CollectionUtils.isNotEmpty(getFreelancerIds());
    }

    public boolean hasClientIds() {
        return CollectionUtils.isNotEmpty(getClientIds());
    }

    public boolean hasProjectIds() {
        return CollectionUtils.isNotEmpty(getProjectIds());
    }

    public boolean hasStatuses() {
        return CollectionUtils.isNotEmpty(getStatuses());
    }

    public boolean isEmpty() {
        return !(hasFreelancerIds() && hasClientIds() && hasProjectIds() && hasStatuses());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<Long> freelancerIds = Collections.emptyList();
        private List<Long> clientIds = Collections.emptyList();
        private List<Long> projectIds = Collections.emptyList();
        private Collection<FreelancerProjectStatus> statuses = Collections.emptySet();
        private Boolean isStarted = null;

        private Builder() {
        }

        public Builder withFreelancerIds(List<Long> freelancerIds) {
            this.freelancerIds = freelancerIds;
            return this;
        }

        public Builder withFreelancerIds(Long... freelancerIds) {
            this.freelancerIds = asList(freelancerIds);
            return this;
        }

        public Builder withClientIds(List<Long> clientIds) {
            this.clientIds = clientIds;
            return this;
        }

        public Builder withClientIds(Long... clientIds) {
            this.clientIds = asList(clientIds);
            return this;
        }

        public Builder withProjectIds(Long... projectIds) {
            this.projectIds = asList(projectIds);
            return this;
        }

        public Builder withStatuses(FreelancerProjectStatus... statuses) {
            this.statuses = asList(statuses);
            return this;
        }

        public Builder withStatuses(Collection<FreelancerProjectStatus> statuses) {
            this.statuses = statuses;
            return this;
        }

        public Builder withStarted(Boolean started) {
            isStarted = started;
            return this;
        }

        public FreelancerProjectQueryContainer build() {
            return new FreelancerProjectQueryContainer(freelancerIds, clientIds, projectIds, statuses, isStarted);
        }
    }
}
