package ru.yandex.direct.core.entity.freelancer.container;

import javax.annotation.Nonnull;

import ru.yandex.direct.config.DirectConfig;

public class SenderKeys {
    private final String onRequestToClient;
    private final String onRequestToFreelancer;
    private final String onAcceptToFreelancer;
    private final String onAcceptToClient;
    private final String onRescindToClient;
    private final String onRescindToFreelancer;
    private final String onCancelToClient;
    private final String onCancelToFreelancer;

    public SenderKeys(@Nonnull DirectConfig keys) {
        onRequestToClient = keys.getString("on_request_to_client");
        onRequestToFreelancer = keys.getString("on_request_to_freelancer");
        onAcceptToClient = keys.getString("on_accept_to_client");
        onAcceptToFreelancer = keys.getString("on_accept_to_freelancer");
        onRescindToClient = keys.getString("on_rescind_to_client");
        onRescindToFreelancer = keys.getString("on_rescind_to_freelancer");
        onCancelToClient = keys.getString("on_cancel_to_client");
        onCancelToFreelancer = keys.getString("on_cancel_to_freelancer");
    }

    public String getOnRequestToClient() {
        return onRequestToClient;
    }

    public String getOnRequestToFreelancer() {
        return onRequestToFreelancer;
    }

    public String getOnAcceptToFreelancer() {
        return onAcceptToFreelancer;
    }

    public String getOnAcceptToClient() {
        return onAcceptToClient;
    }

    public String getOnRescindToClient() {
        return onRescindToClient;
    }

    public String getOnRescindToFreelancer() {
        return onRescindToFreelancer;
    }

    public String getOnCancelToClient() {
        return onCancelToClient;
    }

    public String getOnCancelToFreelancer() {
        return onCancelToFreelancer;
    }
}
