package ru.yandex.direct.core.entity.freelancer.model;

/**
 * Фрилансер и его карточка в БД хранятся раздельно. Этот класс связывает модель {@link Freelancer}
 * с моделью {@link FreelancerCard}.
 */
public class Freelancer extends FreelancerBase {
    private FreelancerCard card;

    /**
     * В возвращаемую карточку устанавливается {@code id} из {@link #getId()}
     */
    public FreelancerCard getCard() {
        return card;
    }

    public Freelancer withCard(FreelancerCard card) {
        this.card = card;
        return this;
    }

    public static Freelancer fromBaseModel(FreelancerBase base) {
        Freelancer result = new Freelancer();
        result.withId(base.getId())
                .withIsSearchable(base.getIsSearchable())
                .withIsDisabled(base.getIsDisabled())
                .withStatus(base.getStatus())
                .withRating(base.getRating())
                .withFirstName(base.getFirstName())
                .withSecondName(base.getSecondName())
                .withCertLogin(base.getCertLogin())
                .withRegionId(base.getRegionId())
                .withFeedbackCount(base.getFeedbackCount())
                .withCertificates(base.getCertificates())
                .withAdvQualityRating(base.getAdvQualityRating())
                .withAdvQualityRank(base.getAdvQualityRank());
        return result;
    }
}
