package ru.yandex.direct.core.entity.freelancer.operation;

import java.util.List;

import ru.yandex.direct.core.entity.freelancer.model.Freelancer;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerCard;
import ru.yandex.direct.core.entity.freelancer.model.FreelancersCardStatusModerate;
import ru.yandex.direct.core.entity.freelancer.repository.FreelancerRepository;
import ru.yandex.direct.core.entity.freelancer.service.validation.AddFreelancerValidationService;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.add.SimpleAbstractAddOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class FreelancerAddOperation extends SimpleAbstractAddOperation<Freelancer, Long> {
    private final FreelancerRepository freelancerRepository;
    private final AddFreelancerValidationService addFreelancerValidationService;

    private final int shard;

    public FreelancerAddOperation(
            List<Freelancer> models,
            FreelancerRepository freelancerRepository,
            AddFreelancerValidationService addFreelancerValidationService, int shard) {
        super(Applicability.FULL, models);
        this.freelancerRepository = freelancerRepository;
        this.addFreelancerValidationService = addFreelancerValidationService;
        this.shard = shard;
    }

    @Override
    protected void validate(ValidationResult<List<Freelancer>, Defect> preValidationResult) {
        ValidationResult<List<Freelancer>, Defect> validationResult =
                addFreelancerValidationService.validate(getModels());
        preValidationResult.merge(validationResult);
    }

    @Override
    protected List<Long> execute(List<Freelancer> validModelsToApply) {
        for (Freelancer freelancer : validModelsToApply) {
            FreelancerCard card = freelancer.getCard()
                    .withFreelancerId(freelancer.getFreelancerId());
            if (card.getStatusModerate() == null) {
                card.withStatusModerate(FreelancersCardStatusModerate.DRAFT);
            }
            if (card.getIsArchived() == null) {
                card.withIsArchived(false);
            }
        }
        freelancerRepository.addFreelancers(shard, validModelsToApply);
        return mapList(validModelsToApply, Freelancer::getId);
    }
}
