package ru.yandex.direct.core.entity.freelancer.operation;

import java.util.List;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerCard;
import ru.yandex.direct.core.entity.freelancer.repository.FreelancerCardRepository;
import ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerCardValidationService;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.add.SimpleAbstractAddOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Операция добавления карточки фрилансера {@link FreelancerCard}
 */
public class FreelancerCardAddOperation extends SimpleAbstractAddOperation<FreelancerCard, Long> {
    private final FreelancerCardRepository freelancerCardRepository;
    private final FreelancerCardValidationService validationService;
    private final int shard;

    public FreelancerCardAddOperation(
            List<FreelancerCard> models,
            FreelancerCardRepository freelancerCardRepository,
            FreelancerCardValidationService validationService,
            int shard) {
        super(Applicability.FULL, models);
        this.freelancerCardRepository = freelancerCardRepository;
        this.validationService = validationService;
        this.shard = shard;
    }

    @Override
    protected void validate(ValidationResult<List<FreelancerCard>, Defect> preValidationResult) {
        ValidationResult<List<FreelancerCard>, Defect> validationResult = validationService.validate(getModels());
        preValidationResult.merge(validationResult);
    }

    @Override
    protected List<Long> execute(List<FreelancerCard> validModelsToApply) {
        return freelancerCardRepository.addFreelancerCards(shard, validModelsToApply);
    }
}
