package ru.yandex.direct.core.entity.freelancer.operation;

import java.util.List;
import java.util.Optional;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerSkillOffer;
import ru.yandex.direct.core.entity.freelancer.repository.FreelancerSkillsRepository;
import ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerSkillOffersValidationService;
import ru.yandex.direct.operation.Operation;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public class FreelancerSkillOffersSetOperation implements Operation<FreelancerSkillOffer> {

    private final List<FreelancerSkillOffer> freelancerSkillOffers;
    private final FreelancerSkillOffersValidationService validationService;
    private final int shard;
    private final FreelancerSkillsRepository freelancerSkillsRepository;
    private ValidationResult<List<FreelancerSkillOffer>, Defect> validationResult = null;

    public FreelancerSkillOffersSetOperation(int shard,
                                             List<FreelancerSkillOffer> freelancerSkillOffers,
                                             FreelancerSkillOffersValidationService setFreelancerSkillOffersValidationService,
                                             FreelancerSkillsRepository freelancerSkillsRepository) {
        this.freelancerSkillOffers = freelancerSkillOffers;
        this.validationService = setFreelancerSkillOffersValidationService;
        this.shard = shard;
        this.freelancerSkillsRepository = freelancerSkillsRepository;
    }

    @Override
    public Optional<MassResult<FreelancerSkillOffer>> prepare() {
        this.validationResult = validationService.validate(freelancerSkillOffers);
        if (validationResult.hasAnyErrors()) {
            return Optional.of(MassResult.brokenMassAction(freelancerSkillOffers, validationResult));
        }
        return Optional.empty();
    }

    @Override
    public MassResult<FreelancerSkillOffer> apply() {
        freelancerSkillsRepository.insertOrUpdate(shard, freelancerSkillOffers);
        return MassResult.successfulMassAction(freelancerSkillOffers, validationResult);
    }

    @Override
    public MassResult<FreelancerSkillOffer> cancel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<MassResult<FreelancerSkillOffer>> getResult() {
        if (validationResult == null) {
            return Optional.empty();
        }
        if (validationResult.hasAnyErrors()) {
            return Optional.of(MassResult.brokenMassAction(freelancerSkillOffers, validationResult));
        }
        return Optional.of(MassResult.successfulMassAction(freelancerSkillOffers, validationResult));
    }
}
