package ru.yandex.direct.core.entity.freelancer.repository;

import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.freelancer.model.FreelancersCardDeclineReason;

import static java.util.Collections.emptySet;
import static java.util.stream.Collectors.joining;

class FreelancerCardMappings {
    private static final Map<String, FreelancersCardDeclineReason> FREELANCERS_CARD_DECLINE_REASON_BY_DB_NAME;

    static {
        FREELANCERS_CARD_DECLINE_REASON_BY_DB_NAME =
                StreamEx.of(FreelancersCardDeclineReason.values())
                        .toMap(FreelancersCardDeclineReason::getDbName, l -> l);
    }

    static String declineReasonsToDb(@Nullable Set<FreelancersCardDeclineReason> declineReason) {
        if (declineReason == null || declineReason.isEmpty()) {
            return "";
        }
        return StreamEx.of(declineReason)
                .map(FreelancersCardDeclineReason::getDbName)
                .sorted()
                .collect(joining(","));
    }

    static Set<FreelancersCardDeclineReason> declineReasonsFromDb(@Nullable String declineReason) {
        if (declineReason == null || declineReason.isEmpty()) {
            return emptySet();
        }
        String[] splitValues = declineReason.split(",");
        return StreamEx.of(splitValues)
                .map(FREELANCERS_CARD_DECLINE_REASON_BY_DB_NAME::get)
                .toSet();
    }
}
