package ru.yandex.direct.core.entity.freelancer.repository;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerCertificate;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerContacts;
import ru.yandex.direct.dbschema.ppc.enums.FreelancersIsSearchable;

import static java.util.Collections.emptyList;
import static org.apache.commons.lang3.StringUtils.isBlank;
import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.utils.JsonUtils.toJson;

class FreelancerMappings {

    private static final BigDecimal DEFAULT_ZERO_RATING = BigDecimal.ZERO;

    @Nullable
    static FreelancerContacts contactsFromJson(@Nullable String json) {
        if (isBlank(json)) {
            return null;
        }
        return fromJson(json, FreelancerContacts.class);
    }

    @Nullable
    static String contactsToJson(@Nullable FreelancerContacts contacts) {
        if (contacts == null) {
            return null;
        }
        return toJson(contacts);
    }

    static List<FreelancerCertificate> certificatesFromJson(@Nullable String json) {
        if (json == null) {
            return emptyList();
        }
        return Arrays.asList(fromJson(json, FreelancerCertificate[].class));
    }

    static String certificatesToJson(@Nullable List<FreelancerCertificate> certificates) {
        if (certificates == null) {
            return null;
        }
        return toJson(certificates);
    }

    @Nullable
    static Double ratingFromDb(@Nullable BigDecimal dbRating) {
        if (dbRating == null) {
            return null;
        }
        if (dbRating.compareTo(DEFAULT_ZERO_RATING) == 0) {
            return null;
        }
        return dbRating.doubleValue();
    }

    @Nullable
    static BigDecimal ratingToDb(@Nullable Double modelRating) {
        if (modelRating == null) {
            return null;
        }
        return BigDecimal.valueOf(modelRating);
    }

    @Nullable
    static Boolean searchableFromDb(@Nullable FreelancersIsSearchable dbIsSearchable) {
        if (dbIsSearchable == null) {
            return null;
        }

        switch (dbIsSearchable) {
            case No:
                return false;
            case Yes:
                return true;
            default:
                throw new IllegalArgumentException("Unexpected enum value: " + dbIsSearchable);
        }
    }

    @Nullable
    static FreelancersIsSearchable searchableToDb(@Nullable Boolean modelValue) {
        if (modelValue == null) {
            return null;
        }
        if (modelValue) {
            return FreelancersIsSearchable.Yes;
        } else {
            return FreelancersIsSearchable.No;
        }
    }
}
