package ru.yandex.direct.core.entity.freelancer.service;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.avatars.client.AvatarsClient;

/**
 * Содержит пул клиентов аватарницы под различные конфигурации серверов аватарницы МДС. В частности должен содержать клиентов работающих с продакшен и тестовой аватарницами.
 */
public class AvatarsClientPool {
    private final Map<String, AvatarsClient> clientPools;
    private final String defaultConfigName;
    private final Set<String> allConfigurationNames;

    public AvatarsClientPool(Map<String, AvatarsClient> clientPools, String defaultConfigName) {
        this.clientPools = Collections.unmodifiableMap(clientPools);
        this.defaultConfigName = defaultConfigName;
        allConfigurationNames = Collections.unmodifiableSet(clientPools.keySet());
    }

    public Set<String> getAllConfigurationNames() {
        return allConfigurationNames;
    }

    public String getDefaultConfigName() {
        return defaultConfigName;
    }

    public AvatarsClient getDefaultClient() {
        return clientPools.get(defaultConfigName);
    }

    public AvatarsClient getClient(String configName) {
        return clientPools.get(configName);
    }
}
