package ru.yandex.direct.core.entity.freelancer.service;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import org.asynchttpclient.AsyncHttpClient;

import ru.yandex.direct.asynchttp.FetcherSettings;
import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.avatars.client.AvatarsClient;
import ru.yandex.direct.avatars.config.AvatarsConfig;
import ru.yandex.direct.avatars.config.ServerConfig;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;

public class AvatarsClientPoolFactory {

    private final Map<String, AvatarsClient> clientPools;

    private final String defaultConfigName;

    public AvatarsClientPoolFactory(DirectConfig avatarsClientConfig, AsyncHttpClient asyncHttpClient,
                                    @Nullable TvmIntegration tvmIntegration, @Nullable TvmService tvmService) {
        defaultConfigName = avatarsClientConfig.getString("default_config_name");
        List<DirectConfig> configs = avatarsClientConfig.getConfigList("configs");
        clientPools = new HashMap<>(configs.size());
        for (DirectConfig envConfig : configs) {
            AvatarsConfig config = new AvatarsConfig(
                    envConfig.getString("name"),
                    new ServerConfig(
                            envConfig.getString("read_server_host"),
                            envConfig.getInt("read_server_port"),
                            envConfig.getString("read_server_schema")
                    ),
                    new ServerConfig(
                            envConfig.getString("write_server_host"),
                            envConfig.getInt("write_server_port"),
                            envConfig.getString("write_server_schema")
                    ),
                    envConfig.getDuration("write_timeout"),
                    envConfig.getString("upload_namespace"),
                    envConfig.findBoolean("prioritypass").orElse(false));
            Duration connectTimeout = envConfig.getDuration("connect_timeout");
            FetcherSettings fetcherSettings = new FetcherSettings().withConnectTimeout(connectTimeout);
            ParallelFetcherFactory parallelFetcherFactory =
                    new ParallelFetcherFactory(asyncHttpClient, fetcherSettings);
            AvatarsClient avatarsClient = new AvatarsClient(config, parallelFetcherFactory, tvmIntegration, tvmService);
            clientPools.put(config.getConfigName(), avatarsClient);
        }
    }

    public AvatarsClientPool getAvatarsClientPool() {
        return new AvatarsClientPool(clientPools, defaultConfigName);
    }

}
