package ru.yandex.direct.core.entity.freelancer.service;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.freelancer.model.ClientAvatarsHost;
import ru.yandex.direct.dbschema.ppc.enums.ClientsAvatarsHostConfigName;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public class AvatarsConfigNameConverter {
    private final Map<String, ClientAvatarsHost> hostByConfigName;
    private final Map<ClientAvatarsHost, String> configNameByHost;

    public AvatarsConfigNameConverter() {
        hostByConfigName = new HashMap<>(ClientAvatarsHost.values().length);
        configNameByHost = new EnumMap<>(ClientAvatarsHost.class);
        for (ClientAvatarsHost value : ClientAvatarsHost.values()) {
            ClientsAvatarsHostConfigName clientsAvatarsHostConfigName = ClientAvatarsHost.toSource(value);
            checkNotNull(clientsAvatarsHostConfigName, "There is no correspond value for '%1$s'", value.name());
            String literalValue = clientsAvatarsHostConfigName.getLiteral();
            hostByConfigName.put(literalValue, value);
            configNameByHost.put(value, literalValue);
        }
    }

    String getConfigName(ClientAvatarsHost clientAvatarsHost) {
        return configNameByHost.get(clientAvatarsHost);
    }

    public ClientAvatarsHost getHost(String configName) {
        ClientAvatarsHost host = hostByConfigName.get(configName);
        checkArgument(host != null, "Avatars configName ('%1$s') is unknown", configName);
        return host;
    }
}
