package ru.yandex.direct.core.entity.freelancer.service.utils;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerCard;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerContacts;

public class FreelancerCardUtils {

    /**
     * Если в карточке фрилансера в контактах задан siteUrl без протокола, то добавляет в начало протокол http://.
     */
    public static void restoreSiteUrlProtocol(FreelancerCard freelancerCard) {
        if (freelancerCard == null || freelancerCard.getContacts() == null) {
            return;
        }
        FreelancerContacts contacts = freelancerCard.getContacts();
        String siteUrl = contacts.getSiteUrl();
        if (siteUrl == null
                || siteUrl.isEmpty()
                || siteUrl.startsWith("http://")
                || siteUrl.startsWith("https://")) {
            return;
        }
        contacts.setSiteUrl("http://" + siteUrl);
    }
}
